/*
 * Decompiled with CFR 0.152.
 */
package tcb.spiderstpo.common.entity.movement;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.pathfinder.BinaryHeap;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.Target;

public class CustomPathFinder
extends PathFinder {
    private final BinaryHeap path = new BinaryHeap();
    private final Node[] pathOptions = new Node[32];
    private final NodeEvaluator nodeProcessor;
    private int maxExpansions = 200;
    public static final Heuristic DEFAULT_HEURISTIC = (start, end, isTargetHeuristic) -> start.m_77304_(end);
    private Heuristic heuristic = DEFAULT_HEURISTIC;

    public CustomPathFinder(NodeEvaluator processor, int maxExpansions) {
        super(processor, maxExpansions);
        this.nodeProcessor = processor;
        this.maxExpansions = maxExpansions;
    }

    public NodeEvaluator getNodeProcessor() {
        return this.nodeProcessor;
    }

    public CustomPathFinder setMaxExpansions(int expansions) {
        this.maxExpansions = expansions;
        return this;
    }

    public CustomPathFinder setHeuristic(Heuristic heuristic) {
        this.heuristic = heuristic;
        return this;
    }

    @Nullable
    public Path m_77427_(PathNavigationRegion region, Mob entity, Set<BlockPos> checkpoints, float maxDistance, int checkpointRange, float maxExpansionsMultiplier) {
        this.path.m_77081_();
        this.nodeProcessor.m_6028_(region, entity);
        Node pathpoint = this.nodeProcessor.m_7171_();
        Map<Target, BlockPos> checkpointsMap = checkpoints.stream().collect(Collectors.toMap(pos -> this.nodeProcessor.m_7568_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), Function.identity()));
        Path path = this.findPath(pathpoint, checkpointsMap, maxDistance, checkpointRange, maxExpansionsMultiplier);
        this.nodeProcessor.m_6802_();
        return path;
    }

    @Nullable
    private Path findPath(Node start, Map<Target, BlockPos> checkpointsMap, float maxDistance, int checkpointRange, float maxExpansionsMultiplier) {
        Set<Target> checkpoints = checkpointsMap.keySet();
        start.f_77275_ = 0.0f;
        start.f_77277_ = start.f_77276_ = this.computeHeuristic(start, checkpoints);
        this.path.m_77081_();
        this.path.m_77084_(start);
        HashSet reachedCheckpoints = Sets.newHashSetWithExpectedSize((int)checkpoints.size());
        int expansions = 0;
        int maxExpansions = (int)((float)this.maxExpansions * maxExpansionsMultiplier);
        while (!this.path.m_77092_() && ++expansions < maxExpansions) {
            Node openPathPoint = this.path.m_77091_();
            openPathPoint.f_77279_ = true;
            for (Target checkpoint2 : checkpoints) {
                if (!(openPathPoint.m_77304_((Node)checkpoint2) <= (float)checkpointRange)) continue;
                checkpoint2.m_77509_();
                reachedCheckpoints.add(checkpoint2);
            }
            if (!reachedCheckpoints.isEmpty()) break;
            if (!(openPathPoint.m_77293_(start) < maxDistance)) continue;
            int numOptions = this.nodeProcessor.m_6065_(this.pathOptions, openPathPoint);
            for (int i = 0; i < numOptions; ++i) {
                Node successorPathPoint = this.pathOptions[i];
                float costHeuristic = openPathPoint.m_77293_(successorPathPoint);
                successorPathPoint.f_77280_ = openPathPoint.f_77280_ + costHeuristic;
                float totalSuccessorPathCost = openPathPoint.f_77275_ + costHeuristic + successorPathPoint.f_77281_;
                if (!(successorPathPoint.f_77280_ < maxDistance) || successorPathPoint.m_77303_() && !(totalSuccessorPathCost < successorPathPoint.f_77275_)) continue;
                successorPathPoint.f_77278_ = openPathPoint;
                successorPathPoint.f_77275_ = totalSuccessorPathCost;
                successorPathPoint.f_77276_ = this.computeHeuristic(successorPathPoint, checkpoints) * 1.0f;
                if (successorPathPoint.m_77303_()) {
                    this.path.m_77086_(successorPathPoint, successorPathPoint.f_77275_ + successorPathPoint.f_77276_);
                    continue;
                }
                successorPathPoint.f_77277_ = successorPathPoint.f_77275_ + successorPathPoint.f_77276_;
                this.path.m_77084_(successorPathPoint);
            }
        }
        Optional<Path> path = !reachedCheckpoints.isEmpty() ? reachedCheckpoints.stream().map(checkpoint -> this.createPath(checkpoint.m_77508_(), (BlockPos)checkpointsMap.get(checkpoint), true)).min(Comparator.comparingInt(Path::m_77398_)) : checkpoints.stream().map(checkpoint -> this.createPath(checkpoint.m_77508_(), (BlockPos)checkpointsMap.get(checkpoint), false)).min(Comparator.comparingDouble(Path::m_77407_).thenComparingInt(Path::m_77398_));
        return !path.isPresent() ? null : path.get();
    }

    private float computeHeuristic(Node pathPoint, Set<Target> checkpoints) {
        float minDst = Float.MAX_VALUE;
        for (Target checkpoint : checkpoints) {
            float dst = pathPoint.m_77293_((Node)checkpoint);
            checkpoint.m_77503_(dst, pathPoint);
            minDst = Math.min(dst, minDst);
        }
        return minDst;
    }

    protected Path createPath(Node start, BlockPos target, boolean isTargetReached) {
        ArrayList points = Lists.newArrayList();
        Node currentPathPoint = start;
        points.add(0, start);
        while (currentPathPoint.f_77278_ != null) {
            currentPathPoint = currentPathPoint.f_77278_;
            points.add(0, currentPathPoint);
        }
        return new Path((List)points, target, isTargetReached);
    }

    public static interface Heuristic {
        public float compute(Node var1, Node var2, boolean var3);
    }
}

