/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.decoration;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.block.provider.BlockStateProvider;
import xiroc.dungeoncrawl.dungeon.decoration.DungeonDecoration;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlockType;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;

public record FloorDecoration(BlockStateProvider blockStateProvider, float chance) implements DungeonDecoration
{
    @Override
    public void decorate(DungeonModel model, LevelAccessor world, BlockPos origin, RandomSource random, BoundingBox worldGenBounds, BoundingBox structureBounds, DungeonPiece piece) {
        model.blocks.forEach(block -> {
            BlockPos pos = DungeonDecoration.getRotatedBlockPos(block.position.m_123341_(), block.position.m_123342_() + 1, block.position.m_123343_(), origin, model, piece.f_73379_);
            if (block.type == DungeonModelBlockType.FLOOR && block.position.m_123342_() < model.height - 1 && worldGenBounds.m_71051_((Vec3i)pos) && structureBounds.m_71051_((Vec3i)pos) && !DungeonBuilder.isBlockProtected(world, origin) && world.m_46859_(origin.m_121955_(block.position).m_7494_()) && FloorDecoration.checkSolid(world, origin.m_121955_(block.position), worldGenBounds, structureBounds) && random.m_188501_() < this.chance) {
                world.m_7731_(pos, this.blockStateProvider.get(world, pos, random), 2);
            }
        });
    }

    private static boolean checkSolid(LevelAccessor world, BlockPos pos, BoundingBox worldGenBounds, BoundingBox structureBounds) {
        return worldGenBounds.m_71051_((Vec3i)pos) && structureBounds.m_71051_((Vec3i)pos) && world.m_8055_(pos).m_60815_();
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "floor");
        object.addProperty("chance", (Number)Float.valueOf(this.chance));
        object.add("block", (JsonElement)this.blockStateProvider.serialize());
        return object;
    }

    public record NextToSolid(BlockStateProvider blockStateProvider, float chance) implements DungeonDecoration
    {
        @Override
        public void decorate(DungeonModel model, LevelAccessor world, BlockPos origin, RandomSource random, BoundingBox worldGenBounds, BoundingBox structureBounds, DungeonPiece piece) {
            model.blocks.forEach(block -> {
                BlockPos pos;
                if (block.type == DungeonModelBlockType.FLOOR && block.position.m_123342_() < model.height - 1 && worldGenBounds.m_71051_((Vec3i)(pos = DungeonDecoration.getRotatedBlockPos(block.position.m_123341_(), block.position.m_123342_() + 1, block.position.m_123343_(), origin, model, piece.f_73379_))) && structureBounds.m_71051_((Vec3i)pos) && world.m_46859_(pos) && world.m_8055_(pos.m_7495_()).m_60815_() && !DungeonBuilder.isBlockProtected(world, pos) && (FloorDecoration.checkSolid(world, pos.m_122012_(), worldGenBounds, structureBounds) || FloorDecoration.checkSolid(world, pos.m_122029_(), worldGenBounds, structureBounds) || FloorDecoration.checkSolid(world, pos.m_122019_(), worldGenBounds, structureBounds) || FloorDecoration.checkSolid(world, pos.m_122024_(), worldGenBounds, structureBounds)) && random.m_188501_() < this.chance) {
                    world.m_7731_(pos, this.blockStateProvider.get(world, pos, random), 2);
                }
            });
        }

        @Override
        public JsonObject serialize() {
            JsonObject object = new JsonObject();
            object.addProperty("type", "floor_next_to_solid");
            object.addProperty("chance", (Number)Float.valueOf(this.chance));
            object.add("block", (JsonElement)this.blockStateProvider.serialize());
            return object;
        }
    }
}

