/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips;

import com.anthonyhilyard.legendarytooltips.LegendaryTooltipsConfig;
import com.anthonyhilyard.legendarytooltips.Loader;
import com.anthonyhilyard.legendarytooltips.render.TooltipDecor;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import org.apache.commons.lang3.exception.ExceptionUtils;

public final class FrameResourceParser
implements ResourceManagerReloadListener {
    public static final FrameResourceParser INSTANCE = new FrameResourceParser();

    private FrameResourceParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void m_6213_(ResourceManager resourceManager) {
        try {
            for (Resource resource : resourceManager.m_213829_(new ResourceLocation("legendarytooltips", "frame_definitions.json"))) {
                try {
                    InputStream inputStream = resource.m_215507_();
                    try {
                        JsonObject rootObject = GsonHelper.m_13861_((Reader)new InputStreamReader(inputStream), (boolean)true);
                        if (!rootObject.has("definitions")) continue;
                        JsonArray definitions = GsonHelper.m_13933_((JsonObject)rootObject, (String)"definitions");
                        for (int i = 0; i < definitions.size(); ++i) {
                            Object parsedImage;
                            JsonObject definitionObject = GsonHelper.m_13918_((JsonElement)definitions.get(i), (String)String.format("definitions[%d]", i));
                            ResourceLocation image = TooltipDecor.DEFAULT_BORDERS;
                            int index = 0;
                            int priority = 0;
                            HashMap<String, TextColor> colors = new HashMap<String, TextColor>(){
                                {
                                    this.put("startColor", LegendaryTooltipsConfig.defaultColors.get((Object)LegendaryTooltipsConfig.ColorType.BORDER_START));
                                    this.put("endColor", LegendaryTooltipsConfig.defaultColors.get((Object)LegendaryTooltipsConfig.ColorType.BORDER_END));
                                    this.put("bgColor", LegendaryTooltipsConfig.defaultColors.get((Object)LegendaryTooltipsConfig.ColorType.BG_START));
                                    this.put("bgStartColor", null);
                                    this.put("bgEndColor", null);
                                }
                            };
                            ArrayList<String> selectors = new ArrayList<String>();
                            for (JsonElement selectorElement : GsonHelper.m_13933_((JsonObject)definitionObject, (String)"selectors")) {
                                selectors.add(GsonHelper.m_13805_((JsonElement)selectorElement, (String)"selector"));
                            }
                            if (definitionObject.has("image") && ResourceLocation.m_135830_((String)(parsedImage = GsonHelper.m_13906_((JsonObject)definitionObject, (String)"image")))) {
                                image = new ResourceLocation((String)parsedImage);
                            }
                            if (definitionObject.has("index")) {
                                index = GsonHelper.m_13927_((JsonObject)definitionObject, (String)"index");
                            }
                            if (definitionObject.has("priority")) {
                                priority = GsonHelper.m_13927_((JsonObject)definitionObject, (String)"priority");
                            }
                            parsedImage = colors.keySet().iterator();
                            while (parsedImage.hasNext()) {
                                String colorKey = (String)parsedImage.next();
                                if (!definitionObject.has(colorKey)) continue;
                                LegendaryTooltipsConfig.ColorType colorType = switch (colorKey) {
                                    case "startColor" -> LegendaryTooltipsConfig.ColorType.BORDER_START;
                                    case "endColor" -> LegendaryTooltipsConfig.ColorType.BORDER_END;
                                    default -> LegendaryTooltipsConfig.ColorType.BG_START;
                                    case "bgEndColor" -> LegendaryTooltipsConfig.ColorType.BG_END;
                                };
                                TextColor parsedColor = null;
                                if (GsonHelper.m_13813_((JsonObject)definitionObject, (String)colorKey)) {
                                    parsedColor = LegendaryTooltipsConfig.getColor(GsonHelper.m_13906_((JsonObject)definitionObject, (String)colorKey), null, image, index, colorType);
                                } else if (GsonHelper.m_144762_((JsonObject)definitionObject, (String)colorKey)) {
                                    parsedColor = LegendaryTooltipsConfig.getColor(GsonHelper.m_13921_((JsonObject)definitionObject, (String)colorKey), null, image, index, colorType);
                                }
                                if (parsedColor == null) continue;
                                colors.put(colorKey, parsedColor);
                            }
                            LegendaryTooltipsConfig.FrameDefinition definition = new LegendaryTooltipsConfig.FrameDefinition(image, index, () -> ((TextColor)colors.get("startColor")).m_131265_(), () -> ((TextColor)colors.get("endColor")).m_131265_(), () -> colors.get("bgStartColor") != null ? ((TextColor)colors.get("bgStartColor")).m_131265_() : ((TextColor)colors.get("bgColor")).m_131265_(), () -> colors.get("bgEndColor") != null ? ((TextColor)colors.get("bgEndColor")).m_131265_() : ((TextColor)colors.get("bgColor")).m_131265_(), LegendaryTooltipsConfig.FrameSource.DATA, priority);
                            LegendaryTooltipsConfig.INSTANCE.addFrameDefinition(definition, selectors);
                        }
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                catch (Exception e) {
                    throw e;
                    return;
                }
            }
        }
        catch (Exception e) {
            Loader.LOGGER.warn("An error occurred while parsing frame definitions data:\n {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }
}

