/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.advancement;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.advancement.DyeColorPredicate;
import io.github.mortuusars.chalk.advancement.MaterialColorPredicate;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.LightPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.material.MaterialColor;
import org.jetbrains.annotations.NotNull;

public class ChalkDrawTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    private static final ResourceLocation ID = Chalk.resource("mark_drawn");

    @NotNull
    protected TriggerInstance createInstance(JsonObject json, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EntityPredicate.Composite player, @NotNull DeserializationContext conditionsParser) {
        return new TriggerInstance(player, LocationPredicate.m_52629_((JsonElement)json.get("location")), MaterialColorPredicate.fromJson(json.get("materialColorPredicate")), DyeColorPredicate.fromJson(json.get("colorPredicate")));
    }

    public void trigger(ServerPlayer player, MaterialColor surfaceColor, DyeColor chalkColor) {
        this.m_66234_(player, triggerInstance -> triggerInstance.matches(player, surfaceColor, chalkColor));
    }

    @NotNull
    public ResourceLocation m_7295_() {
        return ID;
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final LocationPredicate location;
        private final MaterialColorPredicate surfaceColor;
        private final DyeColorPredicate chalkColor;

        public TriggerInstance(EntityPredicate.Composite player, LocationPredicate location, MaterialColorPredicate surfaceColor, DyeColorPredicate markColor) {
            super(ID, player);
            this.location = location;
            this.surfaceColor = surfaceColor;
            this.chalkColor = markColor;
        }

        public static TriggerInstance structure(ResourceKey<Structure> structureKey) {
            return new TriggerInstance(EntityPredicate.Composite.f_36667_, LocationPredicate.m_220589_(structureKey), MaterialColorPredicate.ANY, DyeColorPredicate.ANY);
        }

        public static TriggerInstance structureAndLight(ResourceKey<Structure> structureKey, MinMaxBounds.Ints lightLevel) {
            return new TriggerInstance(EntityPredicate.Composite.f_36667_, LocationPredicate.Builder.m_52651_().m_220592_(structureKey).m_153968_(new LightPredicate.Builder().m_153104_(lightLevel).m_153106_()).m_52658_(), MaterialColorPredicate.ANY, DyeColorPredicate.ANY);
        }

        @NotNull
        public JsonObject m_7683_(@NotNull SerializationContext conditions) {
            JsonObject jsonObject = super.m_7683_(conditions);
            jsonObject.add("location", this.location.m_52616_());
            jsonObject.add("materialColorPredicate", this.surfaceColor.serializeToJson());
            jsonObject.add("colorPredicate", this.chalkColor.serializeToJson());
            return jsonObject;
        }

        public boolean matches(ServerPlayer player, MaterialColor surfaceColor, DyeColor chalkColor) {
            return this.location.m_52617_((ServerLevel)player.f_19853_, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_) && this.surfaceColor.matches(surfaceColor) && this.chalkColor.matches(chalkColor);
        }
    }
}

