/*
 * Decompiled with CFR 0.152.
 */
package cech12.unlitcampfire;

import cech12.unlitcampfire.compat.TOPCompat;
import cech12.unlitcampfire.config.ServerConfig;
import cech12.unlitcampfire.mixinaccess.ICampfireBlockEntityMixin;
import cech12.unlitcampfire.mixinaccess.ICampfireBlockMixin;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod(value="unlitcampfire")
@Mod.EventBusSubscriber
public class UnlitCampfireMod {
    public static final String MOD_ID = "unlitcampfire";
    private static final Set<BlockEntity> CAMPFIRES = new HashSet<BlockEntity>();

    public UnlitCampfireMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.SERVER_CONFIG);
        ServerConfig.loadConfig(ServerConfig.SERVER_CONFIG, FMLPaths.GAMEDIR.get().resolve(FMLConfig.defaultConfigPath()).resolve("unlitcampfire-server.toml"));
        if (ModList.get().isLoaded("theoneprobe")) {
            TOPCompat.register();
        }
    }

    public static void addCampfire(BlockEntity blockEntity) {
        if (blockEntity != null && blockEntity.m_58904_() != null && !blockEntity.m_58904_().f_46443_) {
            CAMPFIRES.add(blockEntity);
        }
    }

    @SubscribeEvent
    public static void onSleepFinishTimeEvent(SleepFinishedTimeEvent event) {
        LevelAccessor level = event.getLevel();
        if (level.m_5776_()) {
            return;
        }
        int sleepTime = (int)(event.getNewTime() >= level.m_8044_() ? event.getNewTime() - level.m_8044_() : 24000L - level.m_8044_() + event.getNewTime());
        CAMPFIRES.removeIf(Objects::isNull);
        CAMPFIRES.removeIf(BlockEntity::m_58901_);
        CAMPFIRES.stream().filter(campfire -> (Boolean)campfire.m_58900_().m_61143_((Property)CampfireBlock.f_51227_)).filter(campfire -> (Boolean)campfire.m_58900_().m_61143_((Property)ICampfireBlockMixin.INFINITE) == false).filter(campfire -> campfire instanceof ICampfireBlockEntityMixin).map(campfire -> (ICampfireBlockEntityMixin)campfire).filter(campfire -> campfire.isSoulCampfire() ? (Boolean)ServerConfig.SOUL_CAMPFIRE_AFFECTED_BY_SLEEP_TIME.get() : (Boolean)ServerConfig.CAMPFIRE_AFFECTED_BY_SLEEP_TIME.get()).forEach(campfire -> campfire.removeLitTime(sleepTime));
    }
}

