/*
 * Decompiled with CFR 0.152.
 */
package cech12.unlitcampfire.compat;

import cech12.unlitcampfire.mixinaccess.ICampfireBlockEntityMixin;
import cech12.unlitcampfire.mixinaccess.ICampfireBlockMixin;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public class JadeCompat
implements IWailaPlugin,
IBlockComponentProvider,
IServerDataProvider<BlockEntity> {
    public void register(IWailaCommonRegistration registration) {
        registration.registerBlockDataProvider((IServerDataProvider)this, CampfireBlockEntity.class);
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IBlockComponentProvider)this, CampfireBlock.class);
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig pluginConfig) {
        CompoundTag serverData = accessor.getServerData();
        if (serverData.m_128471_("BurnsInfinite")) {
            tooltip.add((Component)Component.m_237115_((String)"hud.unlitcampfire.infinite"));
        } else if (serverData.m_128441_("LitTime")) {
            tooltip.add((Component)Component.m_237110_((String)"hud.unlitcampfire.n_seconds", (Object[])new Object[]{this.getSecondsLeft(serverData)}));
        }
    }

    private int getSecondsLeft(CompoundTag serverData) {
        return (serverData.m_128451_("MaxLitTime") - serverData.m_128451_("LitTime")) / 20;
    }

    public void appendServerData(CompoundTag data, ServerPlayer player, Level world, BlockEntity blockEntity, boolean showDetails) {
        BlockState blockState = blockEntity.m_58900_();
        if (blockEntity instanceof ICampfireBlockEntityMixin) {
            ICampfireBlockEntityMixin campfireBlockEntity = (ICampfireBlockEntityMixin)blockEntity;
            Block block = blockState.m_60734_();
            if (block instanceof ICampfireBlockMixin) {
                ICampfireBlockMixin campfireBlock = (ICampfireBlockMixin)block;
                data.m_128379_("BurnsInfinite", campfireBlock.burnsInfinite(blockState));
                data.m_128405_("MaxLitTime", campfireBlock.getMaxLitTime(blockState));
                if (!campfireBlock.burnsInfinite(blockState)) {
                    data.m_128405_("LitTime", campfireBlockEntity.getLitTime());
                }
            }
        }
    }

    public ResourceLocation getUid() {
        return new ResourceLocation("unlitcampfire", "campfireinfo");
    }
}

