/*
 * Decompiled with CFR 0.152.
 */
package cech12.unlitcampfire.config;

import cech12.unlitcampfire.mixinaccess.ICampfireBlockMixin;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="unlitcampfire", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ServerConfig {
    public static ForgeConfigSpec SERVER_CONFIG;
    public static final ForgeConfigSpec.IntValue CAMPFIRE_LIT_TIME;
    public static final ForgeConfigSpec.IntValue CAMPFIRE_RAIN_UNLIT_TIME;
    public static final ForgeConfigSpec.IntValue CAMPFIRE_RAIN_PARTICLE_FACTOR;
    public static final ForgeConfigSpec.BooleanValue CAMPFIRE_DROPS_ITEMS_WHEN_UNLIT_BY_TIME_OR_RAIN;
    public static final ForgeConfigSpec.BooleanValue CAMPFIRE_BREAKS_WHEN_UNLIT_BY_TIME;
    public static final ForgeConfigSpec.BooleanValue CAMPFIRE_ADDING_BURNABLES;
    public static final ForgeConfigSpec.BooleanValue CAMPFIRE_AFFECTED_BY_SLEEP_TIME;
    public static final ForgeConfigSpec.BooleanValue GENERATED_CAMPFIRE_IS_LIT_INFINITELY;
    public static final ForgeConfigSpec.IntValue SOUL_CAMPFIRE_LIT_TIME;
    public static final ForgeConfigSpec.IntValue SOUL_CAMPFIRE_RAIN_UNLIT_TIME;
    public static final ForgeConfigSpec.IntValue SOUL_CAMPFIRE_RAIN_PARTICLE_FACTOR;
    public static final ForgeConfigSpec.BooleanValue SOUL_CAMPFIRE_DROPS_ITEMS_WHEN_UNLIT_BY_TIME_OR_RAIN;
    public static final ForgeConfigSpec.BooleanValue SOUL_CAMPFIRE_BREAKS_WHEN_UNLIT_BY_TIME;
    public static final ForgeConfigSpec.BooleanValue SOUL_CAMPFIRE_ADDING_BURNABLES;
    public static final ForgeConfigSpec.BooleanValue SOUL_CAMPFIRE_AFFECTED_BY_SLEEP_TIME;
    public static final ForgeConfigSpec.BooleanValue GENERATED_SOUL_CAMPFIRE_IS_LIT_INFINITELY;

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    private static void setGeneratedCampfireIsLitInfinitely(Block block, boolean litInfinitely) {
        block.m_49959_((BlockState)((BlockState)block.m_49966_().m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(litInfinitely))).m_61124_((Property)ICampfireBlockMixin.INFINITE, (Comparable)Boolean.valueOf(litInfinitely)));
    }

    private static void loadChangedConfigData(ModConfigEvent configEvent) {
        if (!configEvent.getConfig().getModId().equals("unlitcampfire")) {
            return;
        }
        boolean campfireSpawn = (Boolean)configEvent.getConfig().getConfigData().get(GENERATED_CAMPFIRE_IS_LIT_INFINITELY.getPath());
        ServerConfig.setGeneratedCampfireIsLitInfinitely(Blocks.f_50683_, campfireSpawn);
        boolean soulCampfireSpawn = (Boolean)configEvent.getConfig().getConfigData().get(GENERATED_SOUL_CAMPFIRE_IS_LIT_INFINITELY.getPath());
        ServerConfig.setGeneratedCampfireIsLitInfinitely(Blocks.f_50684_, soulCampfireSpawn);
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        ServerConfig.loadChangedConfigData((ModConfigEvent)configEvent);
    }

    @SubscribeEvent
    public static void onChange(ModConfigEvent.Reloading configEvent) {
        ServerConfig.loadChangedConfigData((ModConfigEvent)configEvent);
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("unlitcampfire");
        CAMPFIRE_LIT_TIME = builder.comment("The time (ticks) a campfire burns until it goes out by itself. (2000 ticks default; 0 means it burns forever)").defineInRange("campfireLitTime", 2000, 0, 2000000);
        CAMPFIRE_RAIN_UNLIT_TIME = builder.comment("The time (ticks) a campfire burns until it goes out during rain. (160 ticks [default]; 0: it goes out immediately; -1: it burns during rain).").defineInRange("campfireRainUnlitTime", 160, -1, 2000000);
        CAMPFIRE_RAIN_PARTICLE_FACTOR = builder.comment("The Factor of particle count of a campfire during rain. (2: doubled particles count [default]; 1: same particle count)").defineInRange("campfireRainParticleFactor", 2, 1, 10);
        CAMPFIRE_DROPS_ITEMS_WHEN_UNLIT_BY_TIME_OR_RAIN = builder.comment("Whether the contained items should be dropped when a campfire goes out by itself or by rain.").define("campfireDropsItemsWhenUnlitByTimeOrRain", true);
        CAMPFIRE_BREAKS_WHEN_UNLIT_BY_TIME = builder.comment("Whether a campfire should be destroyed when it goes out by itself.").define("campfireBreaksWhenUnlitByTime", false);
        CAMPFIRE_ADDING_BURNABLES = builder.comment("Whether the lit time of a campfire could be extended with combustible/burnable items.").define("campfireAddingBurnables", true);
        CAMPFIRE_AFFECTED_BY_SLEEP_TIME = builder.comment("Whether the lit time of a campfire should be affected by the sleep time.").define("campfireAffectedBySleepTime", false);
        GENERATED_CAMPFIRE_IS_LIT_INFINITELY = builder.comment("Whether generated campfires should be lit infinitely.").define("generatedCampfireIsLitInfinitely", true);
        SOUL_CAMPFIRE_LIT_TIME = builder.comment("The time (ticks) a soul campfire burns until it goes out by itself. (2000 ticks default; 0 means it burns forever)").defineInRange("soulCampfireLitTime", 2000, 0, 2000000);
        SOUL_CAMPFIRE_RAIN_UNLIT_TIME = builder.comment("The time (ticks) a soul campfire burns until it goes out during rain. (0: it goes out immediately; -1: it burns during rain [default]).").defineInRange("soulCampfireRainUnlitTime", -1, -1, 2000000);
        SOUL_CAMPFIRE_RAIN_PARTICLE_FACTOR = builder.comment("The Factor of particle count of a soul campfire during rain. (2: doubled particles count (default); 1: same particle count)").defineInRange("soulCampfireRainParticleFactor", 2, 1, 10);
        SOUL_CAMPFIRE_DROPS_ITEMS_WHEN_UNLIT_BY_TIME_OR_RAIN = builder.comment("Whether the contained items should be dropped when a soul campfire goes out by itself or by rain.").define("soulCampfireDropsItemsWhenUnlitByTimeOrRain", true);
        SOUL_CAMPFIRE_BREAKS_WHEN_UNLIT_BY_TIME = builder.comment("Whether a soul campfire should be destroyed when it goes out by itself.").define("soulCampfireBreaksWhenUnlitByTime", false);
        SOUL_CAMPFIRE_ADDING_BURNABLES = builder.comment("Whether the lit time of a soul campfire could be extended with combustible/burnable items.").define("soulCampfireAddingBurnables", true);
        SOUL_CAMPFIRE_AFFECTED_BY_SLEEP_TIME = builder.comment("Whether the lit time of a campfire should be affected by the sleep time.").define("soulCampfireAffectedBySleepTime", false);
        GENERATED_SOUL_CAMPFIRE_IS_LIT_INFINITELY = builder.comment("Whether generated soul campfires should be lit infinitely.").define("generatedSoulCampfireIsLitInfinitely", true);
        builder.pop();
        SERVER_CONFIG = builder.build();
    }
}

