/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.connectiblechains;

import com.lilypuree.connectiblechains.CCConfig;
import com.lilypuree.connectiblechains.chain.ChainLink;
import com.lilypuree.connectiblechains.chain.ChainType;
import com.lilypuree.connectiblechains.chain.ChainTypesRegistry;
import com.lilypuree.connectiblechains.compat.BuiltinCompat;
import com.lilypuree.connectiblechains.entity.ChainKnotEntity;
import com.lilypuree.connectiblechains.entity.ChainLinkEntity;
import com.lilypuree.connectiblechains.entity.ModEntityTypes;
import com.lilypuree.connectiblechains.network.ModPacketHandler;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="connectiblechains")
public class ConnectibleChains {
    public static final String MODID = "connectiblechains";
    public static final Logger LOGGER = LogManager.getLogger((String)"connectiblechains");
    public static CCConfig runtimeConfig;

    public ConnectibleChains() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModEntityTypes.register();
        ChainTypesRegistry.init(bus);
        BuiltinCompat.init();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.addListener(this::chainUseEvent);
        runtimeConfig = new CCConfig();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CCConfig.COMMON_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CCConfig.CLIENT_CONFIG);
    }

    public void setup(FMLCommonSetupEvent event) {
        ModPacketHandler.registerMessages();
    }

    private void chainUseEvent(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        BlockHitResult hitResult = event.getHitVec();
        Level world = event.getLevel();
        if (player == null || player.m_6047_()) {
            return;
        }
        ItemStack stack = player.m_21120_(hand);
        BlockPos blockPos = hitResult.m_82425_();
        BlockState block = world.m_8055_(blockPos);
        if (stack.m_41720_() != Items.f_42026_) {
            return;
        }
        if (!ChainKnotEntity.canAttachTo(block)) {
            return;
        }
        if (world.f_46443_) {
            Item handItem = player.m_21120_(hand).m_41720_();
            if (ChainTypesRegistry.ITEM_CHAIN_TYPES.containsKey(handItem)) {
                event.setCanceled(true);
            } else if (ChainKnotEntity.getHeldChainsInRange(player, blockPos).size() > 0) {
                event.setCanceled(true);
            } else if (ChainKnotEntity.getKnotAt(player.f_19853_, blockPos) != null && ChainLinkEntity.canDestroyWith(stack)) {
                event.setCanceled(true);
            }
            if (event.isCanceled()) {
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
            return;
        }
        ChainKnotEntity knot = ChainKnotEntity.getKnotAt(world, blockPos);
        if (knot != null) {
            if (knot.m_6096_(player, hand) == InteractionResult.CONSUME) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.CONSUME);
            }
        } else {
            List<ChainLink> attachableChains = ChainKnotEntity.getHeldChainsInRange(player, blockPos);
            ChainType knotType = ChainTypesRegistry.ITEM_CHAIN_TYPES.get(stack.m_41720_()).get();
            if (attachableChains.size() == 0 && knotType == null) {
                return;
            }
            if (knotType == null) {
                knotType = attachableChains.get((int)0).chainType;
            }
            knot = new ChainKnotEntity(world, blockPos, knotType);
            knot.setGraceTicks((byte)0);
            world.m_7967_((Entity)knot);
            knot.m_7084_();
            InteractionResult result = knot.m_6096_(player, hand);
            event.setCanceled(true);
            event.setCancellationResult(result);
        }
    }
}

