/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.connectiblechains.chain;

import com.lilypuree.connectiblechains.ConnectibleChains;
import com.lilypuree.connectiblechains.chain.ChainType;
import com.lilypuree.connectiblechains.util.Helper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="connectiblechains", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ChainTypesRegistry {
    public static final ResourceLocation DEFAULT_CHAIN_TYPE_ID = Helper.identifier("iron_chain");
    public static Supplier<ChainType> DEFAULT_CHAIN_TYPE;
    public static final ResourceKey<Registry<ChainType>> CHAIN_TYPES;
    public static final DeferredRegister CHAINS;
    private static Supplier<IForgeRegistry<ChainType>> REGISTRY;
    public static Supplier<ChainType> IRON_CHAIN;
    public static final Map<Item, Supplier<ChainType>> ITEM_CHAIN_TYPES;

    public static ResourceLocation getKey(ChainType type) {
        return REGISTRY.get().getKey((Object)type);
    }

    public static ChainType getValue(ResourceLocation id) {
        return (ChainType)REGISTRY.get().getValue(id);
    }

    public static ChainType getValue(String id) {
        return ChainTypesRegistry.getValue(ResourceLocation.m_135820_((String)id));
    }

    public static Collection<ResourceLocation> getKeys() {
        return REGISTRY.get().getKeys();
    }

    @SubscribeEvent
    public static void onNewRegistry(NewRegistryEvent event) {
        DEFAULT_CHAIN_TYPE = ChainTypesRegistry.register(DEFAULT_CHAIN_TYPE_ID.m_135815_(), Items.f_42026_);
        IRON_CHAIN = DEFAULT_CHAIN_TYPE;
    }

    public static Supplier<ChainType> register(String id, Item item) {
        RegistryObject chainType = CHAINS.register("iron_chain", () -> new ChainType(Items.f_42026_));
        ITEM_CHAIN_TYPES.put(item, (Supplier<ChainType>)chainType);
        return chainType;
    }

    public static Supplier<ChainType> register(Item item) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
        if (id == ForgeRegistries.ITEMS.getDefaultKey()) {
            ConnectibleChains.LOGGER.error("Cannot create chain type with unregistered item: {}", (Object)item.m_41466_());
            return DEFAULT_CHAIN_TYPE;
        }
        if (REGISTRY.get().containsKey(id)) {
            return () -> (ChainType)REGISTRY.get().getValue(id);
        }
        Supplier<ChainType> chainType = () -> new ChainType(item);
        ITEM_CHAIN_TYPES.put(item, chainType);
        return chainType;
    }

    public static void init(IEventBus bus) {
        CHAINS.register(bus);
    }

    static {
        CHAIN_TYPES = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("connectiblechains", DEFAULT_CHAIN_TYPE_ID.m_135815_()));
        CHAINS = DeferredRegister.create(CHAIN_TYPES, (String)"connectiblechains");
        REGISTRY = CHAINS.makeRegistry(() -> new RegistryBuilder().setName(new ResourceLocation("connectiblechains", "chain_types")).setDefaultKey(DEFAULT_CHAIN_TYPE_ID));
        ITEM_CHAIN_TYPES = new HashMap<Item, Supplier<ChainType>>();
    }
}

