/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.connectiblechains.client.render.entity;

import com.lilypuree.connectiblechains.ConnectibleChains;
import com.lilypuree.connectiblechains.chain.ChainLink;
import com.lilypuree.connectiblechains.chain.ChainType;
import com.lilypuree.connectiblechains.client.ClientInitializer;
import com.lilypuree.connectiblechains.client.render.entity.ChainRenderer;
import com.lilypuree.connectiblechains.client.render.entity.model.ChainKnotEntityModel;
import com.lilypuree.connectiblechains.entity.ChainKnotEntity;
import com.lilypuree.connectiblechains.util.Helper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ChainKnotEntityRenderer
extends EntityRenderer<ChainKnotEntity> {
    private final ChainKnotEntityModel<ChainKnotEntity> model;
    private final ChainRenderer chainRenderer = new ChainRenderer();

    public ChainKnotEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new ChainKnotEntityModel(context.m_174023_(ClientInitializer.CHAIN_KNOT));
    }

    public ChainRenderer getChainRenderer() {
        return this.chainRenderer;
    }

    public boolean shouldRender(ChainKnotEntity entity, Frustum frustum, double x, double y, double z) {
        if (entity.f_19811_) {
            return true;
        }
        for (ChainLink link : entity.getLinks()) {
            if (link.primary != entity) continue;
            if (link.secondary instanceof Player) {
                return true;
            }
            if (!link.secondary.m_6000_(x, y, z)) continue;
            return true;
        }
        return super.m_5523_((Entity)entity, frustum, x, y, z);
    }

    public void render(ChainKnotEntity chainKnotEntity, float yaw, float partialTicks, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        if (chainKnotEntity.shouldRenderKnot()) {
            matrices.m_85836_();
            Vec3 leashOffset = chainKnotEntity.m_7398_(partialTicks).m_82546_(chainKnotEntity.m_20318_(partialTicks));
            matrices.m_85837_(leashOffset.f_82479_, leashOffset.f_82480_ + 0.40625, leashOffset.f_82481_);
            matrices.m_85841_(0.8333333f, 1.0f, 0.8333333f);
            VertexConsumer vertexConsumer = vertexConsumers.m_6299_(this.model.m_103119_(chainKnotEntity.getChainType().getKnotTexture()));
            this.model.m_7695_(matrices, vertexConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrices.m_85849_();
        }
        for (ChainLink link : chainKnotEntity.getLinks()) {
            if (link.primary != chainKnotEntity || link.isDead()) continue;
            this.renderChainLink(link, partialTicks, matrices, vertexConsumers);
            if (!ConnectibleChains.runtimeConfig.doDebugDraw()) continue;
            this.drawDebugVector(matrices, (Entity)chainKnotEntity, link.secondary, vertexConsumers.m_6299_((RenderType)RenderType.f_110371_));
        }
        if (ConnectibleChains.runtimeConfig.doDebugDraw()) {
            matrices.m_85836_();
            MutableComponent holdingCount = Component.m_237113_((String)("F: " + chainKnotEntity.getLinks().stream().filter(l -> l.primary == chainKnotEntity).count()));
            MutableComponent heldCount = Component.m_237113_((String)("T: " + chainKnotEntity.getLinks().stream().filter(l -> l.secondary == chainKnotEntity).count()));
            matrices.m_85837_(0.0, 0.25, 0.0);
            this.m_7649_((Entity)chainKnotEntity, (Component)holdingCount, matrices, vertexConsumers, light);
            matrices.m_85837_(0.0, 0.25, 0.0);
            this.m_7649_((Entity)chainKnotEntity, (Component)heldCount, matrices, vertexConsumers, light);
            matrices.m_85849_();
        }
        super.m_7392_((Entity)chainKnotEntity, yaw, partialTicks, matrices, vertexConsumers, light);
    }

    private void drawDebugVector(PoseStack matrices, Entity fromEntity, Entity toEntity, VertexConsumer buffer) {
        if (toEntity == null) {
            return;
        }
        Matrix4f modelMat = matrices.m_85850_().m_85861_();
        Vec3 vec = toEntity.m_20182_().m_82546_(fromEntity.m_20182_());
        Vec3 normal = vec.m_82541_();
        buffer.m_85982_(modelMat, 0.0f, 0.0f, 0.0f).m_6122_(0, 255, 0, 255).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
        buffer.m_85982_(modelMat, (float)vec.f_82479_, (float)vec.f_82480_, (float)vec.f_82481_).m_6122_(255, 0, 0, 255).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
    }

    private void renderChainLink(ChainLink link, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumerProvider) {
        ChainKnotEntity fromEntity = link.primary;
        Entity toEntity = link.secondary;
        matrices.m_85836_();
        Vec3 srcPos = fromEntity.m_20182_().m_82549_(fromEntity.m_7939_());
        Vec3 dstPos = toEntity instanceof HangingEntity ? toEntity.m_20182_().m_82549_(toEntity.m_7939_()) : toEntity.m_7398_(tickDelta);
        Vec3 leashOffset = fromEntity.m_7939_();
        matrices.m_85837_(leashOffset.f_82479_, leashOffset.f_82480_, leashOffset.f_82481_);
        ChainType chainType = link.chainType;
        VertexConsumer buffer = vertexConsumerProvider.m_6299_(RenderType.m_110458_((ResourceLocation)chainType.getChainTexture()));
        if (ConnectibleChains.runtimeConfig.doDebugDraw()) {
            buffer = vertexConsumerProvider.m_6299_(RenderType.m_110504_());
        }
        Vector3f offset = Helper.getChainOffset(srcPos, dstPos);
        matrices.m_85837_((double)offset.m_122239_(), 0.0, (double)offset.m_122269_());
        BlockPos blockPosOfStart = new BlockPos(fromEntity.m_20299_(tickDelta));
        BlockPos blockPosOfEnd = new BlockPos(toEntity.m_20299_(tickDelta));
        int blockLightLevelOfStart = fromEntity.f_19853_.m_45517_(LightLayer.BLOCK, blockPosOfStart);
        int blockLightLevelOfEnd = toEntity.f_19853_.m_45517_(LightLayer.BLOCK, blockPosOfEnd);
        int skylightLevelOfStart = fromEntity.f_19853_.m_45517_(LightLayer.SKY, blockPosOfStart);
        int skylightLevelOfEnd = fromEntity.f_19853_.m_45517_(LightLayer.SKY, blockPosOfEnd);
        Vec3 startPos = srcPos.m_82520_((double)offset.m_122239_(), 0.0, (double)offset.m_122269_());
        Vec3 endPos = dstPos.m_82520_((double)(-offset.m_122239_()), 0.0, (double)(-offset.m_122269_()));
        Vector3f chainVec = new Vector3f((float)(endPos.f_82479_ - startPos.f_82479_), (float)(endPos.f_82480_ - startPos.f_82480_), (float)(endPos.f_82481_ - startPos.f_82481_));
        float angleY = -((float)Math.atan2(chainVec.m_122269_(), chainVec.m_122239_()));
        matrices.m_85845_(Quaternion.m_175228_((float)0.0f, (float)angleY, (float)0.0f));
        if (toEntity instanceof HangingEntity) {
            ChainRenderer.BakeKey key = new ChainRenderer.BakeKey(fromEntity.m_20182_(), toEntity.m_20182_());
            this.chainRenderer.renderBaked(buffer, matrices, key, chainVec, blockLightLevelOfStart, blockLightLevelOfEnd, skylightLevelOfStart, skylightLevelOfEnd);
        } else {
            this.chainRenderer.render(buffer, matrices, chainVec, blockLightLevelOfStart, blockLightLevelOfEnd, skylightLevelOfStart, skylightLevelOfEnd);
        }
        matrices.m_85849_();
    }

    public ResourceLocation getTextureLocation(ChainKnotEntity pEntity) {
        return pEntity.getChainType().getKnotTexture();
    }
}

