/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.connectiblechains.client.render.entity;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.lilypuree.connectiblechains.ConnectibleChains;
import com.lilypuree.connectiblechains.chain.ChainTypesRegistry;
import com.lilypuree.connectiblechains.compat.BuiltinCompat;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.Nullable;

public class ChainTextureManager
extends SimplePreparableReloadListener<Map<ResourceLocation, JsonModel>> {
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    private static final ResourceLocation MISSING_ID = new ResourceLocation("connectiblechains", "textures/entity/missing.png");
    private final Object2ObjectMap<ResourceLocation, ResourceLocation> chainTextures = new Object2ObjectOpenHashMap(64);
    private final Object2ObjectMap<ResourceLocation, ResourceLocation> knotTextures = new Object2ObjectOpenHashMap(64);

    protected Map<ResourceLocation, JsonModel> prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        return this.load(pResourceManager);
    }

    protected void apply(Map<ResourceLocation, JsonModel> textureMap, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        this.chainTextures.clear();
        this.knotTextures.clear();
        textureMap.forEach((id, entry) -> {
            this.chainTextures.put(id, (Object)entry.textures.chainTextureId());
            this.knotTextures.put(id, (Object)entry.textures.knotTextureId());
        });
    }

    public Map<ResourceLocation, JsonModel> load(ResourceManager manager) {
        HashMap<ResourceLocation, JsonModel> map = new HashMap<ResourceLocation, JsonModel>();
        for (ResourceLocation chainType : ChainTypesRegistry.getKeys()) {
            manager.m_213713_(ChainTextureManager.getResourceId(ChainTextureManager.getModelId(chainType))).ifPresentOrElse(resource -> {
                try {
                    InputStreamReader reader = new InputStreamReader(resource.m_215507_(), StandardCharsets.UTF_8);
                    JsonModel jsonModel = (JsonModel)GSON.fromJson((Reader)reader, JsonModel.class);
                    map.put(chainType, jsonModel);
                }
                catch (IOException e) {
                    JsonModel builtinModel = this.loadBuiltinModel(manager, chainType);
                    if (builtinModel != null) {
                        map.put(chainType, builtinModel);
                    }
                    ConnectibleChains.LOGGER.error("Missing model for {}.", (Object)chainType, (Object)e);
                }
            }, () -> ConnectibleChains.LOGGER.error("Failed to load model for {}.", (Object)chainType));
        }
        return map;
    }

    public static ResourceLocation getResourceId(ResourceLocation modelId) {
        return new ResourceLocation(modelId.m_135827_(), "models/" + modelId.m_135815_() + ".json");
    }

    public static ResourceLocation getModelId(ResourceLocation chainType) {
        return new ResourceLocation(chainType.m_135827_(), "entity/chain/" + chainType.m_135815_());
    }

    @Nullable
    private JsonModel loadBuiltinModel(ResourceManager manager, ResourceLocation chainType) {
        Optional resource;
        if (BuiltinCompat.BUILTIN_TYPES.contains(chainType) && (resource = manager.m_213713_(ChainTextureManager.getBuiltinResourceId(ChainTextureManager.getModelId(chainType)))).isPresent()) {
            try {
                InputStreamReader reader = new InputStreamReader(((Resource)resource.get()).m_215507_(), StandardCharsets.UTF_8);
                return (JsonModel)GSON.fromJson((Reader)reader, JsonModel.class);
            }
            catch (Exception e) {
                ConnectibleChains.LOGGER.error("Error for builtin type {}.", (Object)chainType, (Object)e);
            }
        }
        return null;
    }

    private static ResourceLocation getBuiltinResourceId(ResourceLocation modelId) {
        return new ResourceLocation("connectiblechains", "models/" + modelId.m_135815_() + ".json");
    }

    public ResourceLocation getChainTexture(ResourceLocation chainType) {
        return (ResourceLocation)this.chainTextures.getOrDefault((Object)chainType, (Object)MISSING_ID);
    }

    public ResourceLocation getKnotTexture(ResourceLocation chainType) {
        return (ResourceLocation)this.knotTextures.getOrDefault((Object)chainType, (Object)MISSING_ID);
    }

    protected static final class JsonModel {
        public Textures textures;

        protected JsonModel() {
        }

        protected static final class Textures {
            public String chain;
            public String knot;

            protected Textures() {
            }

            public ResourceLocation chainTextureId() {
                return new ResourceLocation(this.chain + ".png");
            }

            public ResourceLocation knotTextureId() {
                return new ResourceLocation(this.knot + ".png");
            }
        }
    }
}

