/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.connectiblechains.datafixer;

import com.lilypuree.connectiblechains.ConnectibleChains;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public abstract class NbtFixer {
    private static final String DATA_VERSION_KEY = "connectiblechains_DataVersion";
    private final SortedMap<Integer, List<NamedFix>> fixes = new TreeMap<Integer, List<NamedFix>>();

    public NbtFixer() {
        this.registerFixers();
    }

    public abstract void registerFixers();

    public CompoundTag update(CompoundTag nbt) {
        ListTag entities = nbt.m_128437_("Entities", 10);
        for (Tag entity : entities) {
            this.updateEntity((CompoundTag)entity);
        }
        return nbt;
    }

    protected void updateEntity(CompoundTag nbt) {
        int currentVersion = nbt.m_128451_(DATA_VERSION_KEY);
        if (currentVersion >= this.getVersion()) {
            return;
        }
        if (!nbt.m_128461_("id").startsWith("connectiblechains")) {
            return;
        }
        for (Map.Entry<Integer, List<NamedFix>> entry : this.fixes.entrySet()) {
            if (entry.getKey() <= currentVersion) continue;
            for (NamedFix namedFix : entry.getValue()) {
                try {
                    nbt = namedFix.fix.apply(nbt);
                }
                catch (Exception e) {
                    ConnectibleChains.LOGGER.error("During fix '{}' for '{}': ", (Object)namedFix.name, (Object)nbt, (Object)e);
                }
            }
        }
    }

    protected abstract int getVersion();

    public void addVersionTag(CompoundTag nbt) {
        nbt.m_128405_(DATA_VERSION_KEY, this.getVersion());
    }

    protected void addFix(int version, String name, Fix fix) {
        if (!this.fixes.containsKey(version)) {
            this.fixes.put(version, new ArrayList());
        }
        ((List)this.fixes.get(version)).add(new NamedFix(name, fix));
    }

    private record NamedFix(String name, Fix fix) {
    }

    static interface Fix {
        public CompoundTag apply(CompoundTag var1);
    }
}

