/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.connectiblechains.network;

import com.lilypuree.connectiblechains.client.ClientInitializer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class S2CChainDetachPacket {
    public static ResourceLocation S2C_CHAIN_DETACH_PACKET_ID = new ResourceLocation("connectiblechains", "s2c_chain_detach_packet_id");
    private int fromId;
    private int toId;

    public S2CChainDetachPacket(int fromId, int toId) {
        this.fromId = fromId;
        this.toId = toId;
    }

    public S2CChainDetachPacket(FriendlyByteBuf buf) {
        this.fromId = buf.readInt();
        this.toId = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.fromId);
        buf.writeInt(this.toId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientInitializer.chainPacketHandler.removeLink(this.fromId, this.toId));
        return true;
    }
}

