/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.core.search;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import mezz.jei.core.collect.SetMultiMap;
import mezz.jei.core.search.ISearchStorage;
import mezz.jei.core.search.suffixtree.GeneralizedSuffixTree;

public class LimitedStringStorage<T>
implements ISearchStorage<T> {
    private final SetMultiMap<String, T> multiMap = new SetMultiMap(() -> Collections.newSetFromMap(new IdentityHashMap()));
    private final GeneralizedSuffixTree<Set<T>> generalizedSuffixTree = new GeneralizedSuffixTree();

    @Override
    public void getSearchResults(String token, Set<T> results) {
        Set<Set> intermediateResults = Collections.newSetFromMap(new IdentityHashMap());
        this.generalizedSuffixTree.getSearchResults(token, intermediateResults);
        for (Set set : intermediateResults) {
            results.addAll(set);
        }
    }

    @Override
    public void getAllElements(Set<T> results) {
        Collection values = this.multiMap.allValues();
        results.addAll(values);
    }

    @Override
    public void put(String key, T value) {
        boolean isNewKey = !this.multiMap.containsKey(key);
        this.multiMap.put(key, value);
        if (isNewKey) {
            Collection set = this.multiMap.get((Object)key);
            this.generalizedSuffixTree.put(key, (Set<Collection>)set);
        }
    }

    @Override
    public String statistics() {
        return "LimitedStringStorage: " + this.generalizedSuffixTree.statistics();
    }
}

