/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.api.net;

import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import nl.enjarai.doabarrelroll.DoABarrelRoll;
import nl.enjarai.doabarrelroll.api.net.SyncableConfig;
import nl.enjarai.doabarrelroll.api.util.DelayedRunnable;
import org.slf4j.Logger;

public class HandshakeServer<T extends SyncableConfig<T>> {
    private final Supplier<T> configSupplier;
    private final Map<ServerPlayer, HandshakeState> syncStates = new WeakHashMap<ServerPlayer, HandshakeState>();
    private final ArrayList<DelayedRunnable> scheduledTasks = new ArrayList();

    public HandshakeServer(Supplier<T> configSupplier) {
        this.configSupplier = configSupplier;
    }

    public void tick(MinecraftServer server) {
        this.scheduledTasks.removeIf(DelayedRunnable::isDone);
        this.scheduledTasks.forEach(DelayedRunnable::tick);
    }

    public HandshakeState getHandshakeState(ServerPlayer player) {
        return this.syncStates.getOrDefault(player, HandshakeState.NOT_SENT);
    }

    public FriendlyByteBuf getConfigSyncBuf(ServerPlayer player) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        SyncableConfig config = (SyncableConfig)this.configSupplier.get();
        DataResult data = config.getTransferCodec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)config);
        try {
            buf.m_130070_(((JsonElement)data.getOrThrow(false, arg_0 -> ((Logger)DoABarrelRoll.LOGGER).error(arg_0))).toString());
        }
        catch (RuntimeException e) {
            DoABarrelRoll.LOGGER.error("Failed to encode config", (Throwable)e);
            buf.m_130070_("{}");
        }
        return buf;
    }

    public void configSentToClient(ServerPlayer player) {
        this.syncStates.put(player, HandshakeState.SENT);
        SyncableConfig config = (SyncableConfig)this.configSupplier.get();
        if (config.getSyncTimeout() != null) {
            this.scheduledTasks.add(new DelayedRunnable(config.getSyncTimeout(), () -> {
                if (this.syncStates.getOrDefault(player, HandshakeState.NOT_SENT) != HandshakeState.ACCEPTED) {
                    DoABarrelRoll.LOGGER.warn("{} did not accept config syncing, config indicates we kick them.", (Object)player.m_7755_().getString());
                    player.f_8906_.m_9942_(config.getSyncTimeoutMessage());
                }
            }));
        }
    }

    public HandshakeState clientReplied(ServerPlayer player, FriendlyByteBuf buf) {
        HandshakeState state = this.getHandshakeState(player);
        if (state == HandshakeState.SENT) {
            if (buf.readBoolean()) {
                this.syncStates.put(player, HandshakeState.ACCEPTED);
                DoABarrelRoll.LOGGER.info("Client of {} accepted server config.", (Object)player.m_7755_().getString());
                return HandshakeState.ACCEPTED;
            }
            this.syncStates.put(player, HandshakeState.FAILED);
            DoABarrelRoll.LOGGER.warn("Client of {} failed to process server config, check client logs find what went wrong.", (Object)player.m_7755_().getString());
            return HandshakeState.FAILED;
        }
        return state;
    }

    public void playerDisconnected(ServerPlayer player) {
        this.syncStates.remove(player);
    }

    public static enum HandshakeState {
        NOT_SENT,
        SENT,
        ACCEPTED,
        FAILED;

    }
}

