/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.moonlightconfigs.forge;

import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import nl.enjarai.doabarrelroll.moonlightconfigs.ConfigBuilder;
import nl.enjarai.doabarrelroll.moonlightconfigs.ConfigType;
import nl.enjarai.doabarrelroll.moonlightconfigs.forge.ConfigSpecWrapper;
import nl.enjarai.doabarrelroll.util.CombinedValue;
import nl.enjarai.doabarrelroll.util.Value;

public class ConfigBuilderImpl
extends ConfigBuilder {
    private final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    private String cat = null;

    public static ConfigBuilder create(ResourceLocation name, ConfigType type) {
        return new ConfigBuilderImpl(name, type);
    }

    public ConfigBuilderImpl(ResourceLocation name, ConfigType type) {
        super(name, type);
    }

    @Override
    protected String currentCategory() {
        return this.cat;
    }

    @Override
    public ConfigSpecWrapper build() {
        return new ConfigSpecWrapper(this.getName(), this.builder.build(), this.type, this.synced, this.changeCallback);
    }

    @Override
    public ConfigBuilderImpl push(String category) {
        assert (this.cat == null);
        this.builder.push(category);
        this.cat = category;
        return this;
    }

    @Override
    public ConfigBuilderImpl pop() {
        assert (this.cat != null);
        this.builder.pop();
        this.cat = null;
        return this;
    }

    @Override
    public Value<Boolean> define(String name, boolean defaultValue) {
        this.maybeAddTranslationString(name);
        ForgeConfigSpec.BooleanValue value = this.builder.define(name, defaultValue);
        return new CombinedValue<Boolean>(arg_0 -> ((ForgeConfigSpec.BooleanValue)value).set(arg_0), (Supplier<Boolean>)value);
    }

    @Override
    public Value<Double> define(String name, double defaultValue, double min, double max) {
        this.maybeAddTranslationString(name);
        ForgeConfigSpec.DoubleValue value = this.builder.defineInRange(name, defaultValue, min, max);
        return new CombinedValue<Double>(arg_0 -> ((ForgeConfigSpec.DoubleValue)value).set(arg_0), (Supplier<Double>)value);
    }

    @Override
    public Value<Integer> define(String name, int defaultValue, int min, int max) {
        this.maybeAddTranslationString(name);
        ForgeConfigSpec.IntValue value = this.builder.defineInRange(name, defaultValue, min, max);
        return new CombinedValue<Integer>(arg_0 -> ((ForgeConfigSpec.IntValue)value).set(arg_0), (Supplier<Integer>)value);
    }

    @Override
    public Value<Integer> defineColor(String name, int defaultValue) {
        this.maybeAddTranslationString(name);
        ForgeConfigSpec.ConfigValue stringConfig = this.builder.define(name, (Object)Integer.toHexString(defaultValue), ConfigBuilder.COLOR_CHECK);
        return new CombinedValue<Integer>(value -> stringConfig.set((Object)Integer.toHexString(value)), () -> Integer.parseUnsignedInt(((String)stringConfig.get()).replace("0x", ""), 16));
    }

    @Override
    public Value<String> define(String name, String defaultValue, Predicate<Object> validator) {
        this.maybeAddTranslationString(name);
        ForgeConfigSpec.ConfigValue stringConfig = this.builder.define(name, (Object)defaultValue, validator);
        return new CombinedValue<String>(arg_0 -> ((ForgeConfigSpec.ConfigValue)stringConfig).set(arg_0), (Supplier<String>)stringConfig);
    }

    @Override
    public <T extends String> Value<List<String>> define(String name, List<? extends T> defaultValue, Predicate<Object> predicate) {
        this.maybeAddTranslationString(name);
        ForgeConfigSpec.ConfigValue value = this.builder.defineList(name, defaultValue, predicate);
        return new CombinedValue<List<String>>(val -> {
            throw new UnsupportedOperationException("Forge is bad");
        }, () -> (List)value.get());
    }

    public <T> Value<List<? extends T>> defineForgeList(String name, List<? extends T> defaultValue, Predicate<Object> predicate) {
        this.maybeAddTranslationString(name);
        ForgeConfigSpec.ConfigValue value = this.builder.defineList(name, defaultValue, predicate);
        return new CombinedValue<List<? extends T>>(val -> {
            throw new UnsupportedOperationException("Forge is bad");
        }, value);
    }

    @Override
    public <V extends Enum<V>> Value<V> define(String name, V defaultValue) {
        this.maybeAddTranslationString(name);
        ForgeConfigSpec.EnumValue value = this.builder.defineEnum(name, defaultValue);
        return new CombinedValue<Enum>(arg_0 -> ((ForgeConfigSpec.EnumValue)value).set(arg_0), (Supplier<Enum>)value);
    }

    @Override
    public ConfigBuilder comment(String comment) {
        this.builder.comment(comment);
        return super.comment(comment);
    }
}

