/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.screens;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotImageHolder;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotImageList;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

class EnlargedScreenshotScreen
extends Screen {
    @Nullable
    private ScreenshotImageHolder showing;
    @Nullable
    private ScreenshotImageList imageList;
    private final Button doneBtn = new Button(0, 0, 52, 20, CommonComponents.f_130655_, btn -> this.m_7379_());
    private final Button nextBtn;
    private final Button prevBtn = new Button(0, 0, 20, 20, (Component)Component.m_237113_((String)"<"), btn -> this.previousScreenshot());

    EnlargedScreenshotScreen() {
        super((Component)Component.m_237119_());
        this.nextBtn = new Button(0, 0, 20, 20, (Component)Component.m_237113_((String)">"), btn -> this.nextScreenshot());
    }

    void show(ScreenshotImageHolder showing, ScreenshotImageList imageList) {
        this.showing = showing;
        this.imageList = imageList;
        this.updateButtonsState();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        this.addUpdatedButton(this.doneBtn, (this.f_96543_ - 52) / 2, this.f_96544_ - 20 - 8);
        this.addUpdatedButton(this.prevBtn, 8, (this.f_96544_ - 20) / 2);
        this.addUpdatedButton(this.nextBtn, this.f_96543_ - 8 - 20, (this.f_96544_ - 20) / 2);
    }

    private void addUpdatedButton(Button button, int x, int y) {
        button.f_93620_ = x;
        button.f_93621_ = y;
        this.m_142416_((GuiEventListener)button);
    }

    private void nextScreenshot() {
        int i;
        if (this.hasInfo() && (i = this.showing.indexInList() + 1) < this.imageList.size()) {
            this.showing = this.imageList.getScreenshot(i);
            this.updateButtonsState();
        }
    }

    private void previousScreenshot() {
        int i;
        if (this.hasInfo() && (i = this.showing.indexInList() - 1) >= 0) {
            this.showing = this.imageList.getScreenshot(i);
            this.updateButtonsState();
        }
    }

    private void updateButtonsState() {
        if (this.hasInfo()) {
            int i = this.showing.indexInList();
            this.prevBtn.f_93623_ = i > 0;
            this.nextBtn.f_93623_ = i < this.imageList.size() - 1;
        }
    }

    private boolean hasInfo() {
        return this.showing != null && this.imageList != null;
    }

    boolean renders() {
        return this.hasInfo();
    }

    public void m_7333_(PoseStack matrices) {
        this.m_93179_(matrices, 0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (this.showing != null) {
            int spacing = 8;
            NativeImage image = this.showing.image();
            if (image != null) {
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157453_((int)0, (int)this.showing.imageId());
                RenderSystem.m_69478_();
                float imgRatio = (float)image.m_84982_() / (float)image.m_85084_();
                int texHeight = this.f_96544_ - 24 - 20;
                int texWidth = (int)((float)texHeight * imgRatio);
                GuiComponent.m_93160_((PoseStack)matrices, (int)((this.f_96543_ - texWidth) / 2), (int)8, (int)texWidth, (int)texHeight, (float)0.0f, (float)0.0f, (int)image.m_84982_(), (int)image.m_85084_(), (int)image.m_84982_(), (int)image.m_85084_());
                RenderSystem.m_69461_();
            }
            super.m_6305_(matrices, mouseX, mouseY, delta);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (amount > 0.0) {
            this.nextScreenshot();
        }
        if (amount < 0.0) {
            this.previousScreenshot();
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 263) {
            this.previousScreenshot();
            return true;
        }
        if (keyCode == 262) {
            this.nextScreenshot();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_7379_() {
        this.showing = null;
        this.imageList = null;
    }
}

