/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.excavated_variants;

import com.google.common.collect.Lists;
import io.github.lukebemish.excavated_variants.ExcavatedVariants;
import io.github.lukebemish.excavated_variants.mixin.IBiomeGenerationSettingsMixin;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class BiomeInjector {
    private static int addingOrdinal = 0;

    public static void addFeatures(Iterable<Biome> biomes) {
        ExcavatedVariants.LOGGER.info("Feature injection started...");
        long start = System.currentTimeMillis();
        for (Biome biome : biomes) {
            BiomeInjector.addSingleFeature(biome, (Holder<PlacedFeature>)Holder.m_205709_((Object)ExcavatedVariants.ORE_REPLACER_PLACED));
        }
        long timeTook = System.currentTimeMillis() - start;
        ExcavatedVariants.LOGGER.info("Feature injection took {} ms to complete.", (Object)timeTook);
    }

    public static void addSingleFeature(Biome biome, Holder<PlacedFeature> supplier) {
        List biomeFeatures = biome.m_47536_().m_47818_();
        ArrayList featureList = biomeFeatures.stream().map(Lists::newArrayList).collect(Collectors.toCollection(ArrayList::new));
        if (addingOrdinal == 0) {
            addingOrdinal = featureList.size();
        }
        while (featureList.size() <= addingOrdinal) {
            featureList.add(Lists.newArrayList());
        }
        ((ArrayList)featureList.get(addingOrdinal)).add(supplier);
        List<HolderSet<PlacedFeature>> outList = featureList.stream().map(x -> HolderSet.m_205800_((List)x)).toList();
        ((IBiomeGenerationSettingsMixin)biome.m_47536_()).setFeatures(outList);
    }
}

