/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.excavated_variants;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.github.lukebemish.dynamic_asset_generator.api.ServerPrePackRepository;
import io.github.lukebemish.excavated_variants.ExcavatedVariants;
import io.github.lukebemish.excavated_variants.data.BaseOre;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;

public class MiningLevelTagGenerator
implements Supplier<Set<ResourceLocation>> {
    private final String level;
    private final ArrayList<CheckPair> toCheck = new ArrayList();

    public MiningLevelTagGenerator(String level) {
        this.level = level;
    }

    public void add(String fullId, BaseOre ore) {
        this.toCheck.add(new CheckPair(fullId, ore.block_id.get(0).toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ResourceLocation> get() {
        HashSet<ResourceLocation> toAdd = new HashSet<ResourceLocation>();
        try {
            List<InputStream> read = ServerPrePackRepository.getResources((ResourceLocation)new ResourceLocation("minecraft", "tags/blocks/needs_" + this.level + "_tool.json")).toList();
            try {
                for (InputStream is2 : read) {
                    StringBuilder textBuilder = new StringBuilder();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is2, StandardCharsets.UTF_8));
                    int c = 0;
                    while ((c = ((Reader)reader).read()) != -1) {
                        textBuilder.append((char)c);
                    }
                    String readStr = textBuilder.toString();
                    JsonElement parser = JsonParser.parseString((String)readStr);
                    if (parser.isJsonObject()) {
                        JsonElement replace = parser.getAsJsonObject().get("replace");
                        if (replace != null && replace.isJsonPrimitive() && replace.getAsJsonPrimitive().isBoolean() && replace.getAsBoolean()) {
                            toAdd.clear();
                        }
                        JsonElement values = parser.getAsJsonObject().get("values");
                        ArrayList<String> entries = new ArrayList<String>();
                        if (values.isJsonArray()) {
                            for (JsonElement i : values.getAsJsonArray()) {
                                if (!i.isJsonPrimitive() || !i.getAsJsonPrimitive().isString()) continue;
                                String str = i.getAsJsonPrimitive().getAsString();
                                entries.addAll(this.parseTagEntry(str));
                            }
                        }
                        for (String str : entries) {
                            for (CheckPair j : this.toCheck) {
                                if (!j.base_id.equals(str) || !Registry.f_122827_.m_7804_(new ResourceLocation("excavated_variants", j.full_id))) continue;
                                toAdd.add(new ResourceLocation("excavated_variants", j.full_id));
                            }
                        }
                    }
                    is2.close();
                }
            }
            catch (IOException e) {
                ExcavatedVariants.LOGGER.error("Could not load mining level tag for {}; will be empty...\n{}", (Object)this.level, (Object)e);
            }
            finally {
                read.forEach(is -> {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
            }
        }
        catch (IOException e) {
            ExcavatedVariants.LOGGER.error("Could not load mining level tag for {}; will be empty...\n{}", (Object)this.level, (Object)e);
        }
        return toAdd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> parseTagEntry(String tagEntry) {
        if (!tagEntry.startsWith("#")) {
            return List.of(tagEntry);
        }
        ArrayList<String> entries = new ArrayList<String>();
        try {
            List<InputStream> read = ServerPrePackRepository.getResources((ResourceLocation)new ResourceLocation("minecraft", "tags/blocks/needs_" + this.level + "_tool.json")).toList();
            try {
                for (InputStream is2 : read) {
                    StringBuilder textBuilder = new StringBuilder();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is2, StandardCharsets.UTF_8));
                    int c = 0;
                    while ((c = ((Reader)reader).read()) != -1) {
                        textBuilder.append((char)c);
                    }
                    String readStr = textBuilder.toString();
                    JsonElement parser = JsonParser.parseString((String)readStr);
                    if (parser.isJsonObject()) {
                        JsonElement values;
                        JsonElement replace = parser.getAsJsonObject().get("replace");
                        if (replace != null && replace.isJsonPrimitive() && replace.getAsJsonPrimitive().isBoolean() && replace.getAsBoolean()) {
                            entries.clear();
                        }
                        if ((values = parser.getAsJsonObject().get("values")).isJsonArray()) {
                            for (JsonElement i : values.getAsJsonArray()) {
                                if (!i.isJsonPrimitive() || !i.getAsJsonPrimitive().isString()) continue;
                                String str = i.getAsJsonPrimitive().getAsString();
                                entries.add(str);
                            }
                        }
                    }
                    is2.close();
                }
                ArrayList<String> arrayList = entries;
                return arrayList;
            }
            catch (IOException e) {
                ExcavatedVariants.LOGGER.error("Could not load tag {}; ignoring...", (Object)tagEntry);
                return List.of();
            }
            finally {
                read.forEach(is -> {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
            }
        }
        catch (IOException e2) {
            ExcavatedVariants.LOGGER.warn("Could not load tag {}; ignoring...", (Object)tagEntry);
        }
        return List.of();
    }

    private record CheckPair(String full_id, String base_id) {
    }
}

