/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.excavated_variants.data.filter;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.github.lukebemish.excavated_variants.ExcavatedVariants;
import io.github.lukebemish.excavated_variants.data.BaseOre;
import io.github.lukebemish.excavated_variants.data.BaseStone;
import io.github.lukebemish.excavated_variants.data.filter.Filter;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface StringHeldFilter
extends Filter {
    public static final Codec<StringHeldFilter> CODEC = Codec.STRING.flatXmap(StringHeldFilter::of, f -> DataResult.success((Object)f.toString()));

    public static DataResult<StringHeldFilter> of(String part) {
        if (part.equals("*")) {
            return DataResult.success((Object)AllFilter.INSTANCE);
        }
        if (part.equals("~")) {
            return DataResult.success((Object)EmptyFilter.INSTANCE);
        }
        if (part.contains(":")) {
            if (part.startsWith("stone:")) {
                return DataResult.success((Object)new StoneFilter(part.replaceFirst("stone:", "")));
            }
            if (part.startsWith("ore:")) {
                return DataResult.success((Object)new OreFilter(part.replaceFirst("ore:", "")));
            }
            if (part.startsWith("type:")) {
                return DataResult.success((Object)new TypeFilter(part.replaceFirst("type:", "")));
            }
            return DataResult.error((String)("Unknown filter type '" + part.split(":")[0] + "'"));
        }
        if (part.startsWith("~")) {
            DataResult<StringHeldFilter> wrapper = StringHeldFilter.of(part.replaceFirst("!", ""));
            return wrapper.map(NotFilter::new);
        }
        return DataResult.success((Object)new VariantFilter(part));
    }

    public static final class AllFilter
    implements StringHeldFilter {
        public static final AllFilter INSTANCE = new AllFilter();

        private AllFilter() {
        }

        @Override
        public boolean matches(BaseOre ore, BaseStone stone) {
            return true;
        }

        @Override
        public boolean matches(String ore, String stone) {
            return true;
        }

        public String toString() {
            return "*";
        }
    }

    public static final class EmptyFilter
    implements StringHeldFilter {
        public static final EmptyFilter INSTANCE = new EmptyFilter();

        private EmptyFilter() {
        }

        @Override
        public boolean matches(BaseOre ore, BaseStone stone) {
            return false;
        }

        @Override
        public boolean matches(String ore, String stone) {
            return false;
        }

        public String toString() {
            return "~";
        }
    }

    public record StoneFilter(String stone) implements StringHeldFilter
    {
        @Override
        public boolean matches(BaseOre ore, BaseStone stone) {
            return this.matches(ore.id, stone.id);
        }

        @Override
        public boolean matches(String ore, String stone) {
            return stone.equals(this.stone());
        }

        @Override
        public String toString() {
            return "stone:" + this.stone();
        }
    }

    public record OreFilter(String ore) implements StringHeldFilter
    {
        @Override
        public boolean matches(BaseOre ore, BaseStone stone) {
            return this.matches(ore.id, stone.id);
        }

        @Override
        public boolean matches(String ore, String stone) {
            return ore.equals(this.ore());
        }

        @Override
        public String toString() {
            return "ore:" + this.ore();
        }
    }

    public record TypeFilter(String type) implements StringHeldFilter
    {
        @Override
        public boolean matches(String ore, String stone) {
            if (ExcavatedVariants.getOres() == null || ExcavatedVariants.getStones() == null) {
                ExcavatedVariants.LOGGER.error("Attempted to access type filter based on string prior to config setup. This should not happen, and is *not good*. Unintended behavior may result. Please report to Excavated Variants.");
                return false;
            }
            return ExcavatedVariants.getOres().get((Object)ore).types.contains(this.type()) && ExcavatedVariants.getStones().get((Object)stone).types.contains(this.type());
        }

        @Override
        public boolean matches(BaseOre ore, BaseStone stone) {
            return ore.types.contains(this.type()) && stone.types.contains(this.type());
        }

        @Override
        public String toString() {
            return "type:" + this.type;
        }
    }

    public record VariantFilter(String variant) implements StringHeldFilter
    {
        @Override
        public boolean matches(BaseOre ore, BaseStone stone) {
            return this.matches(ore.id, stone.id);
        }

        @Override
        public boolean matches(String ore, String stone) {
            return (stone + "_" + ore).equals(this.variant());
        }

        @Override
        public String toString() {
            return this.variant;
        }
    }

    public record NotFilter(StringHeldFilter wrapped) implements StringHeldFilter
    {
        @Override
        public boolean matches(BaseOre ore, BaseStone stone) {
            return this.wrapped.matches(ore, stone);
        }

        @Override
        public boolean matches(String ore, String stone) {
            return !this.wrapped().matches(ore, stone);
        }

        @Override
        public String toString() {
            return "!" + this.wrapped().toString();
        }
    }
}

