/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.excavated_variants.platform;

import io.github.lukebemish.excavated_variants.ICompat;
import io.github.lukebemish.excavated_variants.ICreativeTabLoader;
import io.github.lukebemish.excavated_variants.IMainPlatformTarget;
import io.github.lukebemish.excavated_variants.IPlatform;
import io.github.lukebemish.excavated_variants.IRegistryUtil;
import io.github.lukebemish.excavated_variants.util.ThreadsafeLazy;
import java.util.ServiceLoader;

public class Services {
    public static final IRegistryUtil REGISTRY_UTIL = Services.load(IRegistryUtil.class);
    public static final IPlatform PLATFORM = Services.load(IPlatform.class);
    public static final ThreadsafeLazy<ICreativeTabLoader> CREATIVE_TAB_LOADER = Services.loadLazy(ICreativeTabLoader.class);
    public static final ThreadsafeLazy<IMainPlatformTarget> MAIN_PLATFORM_TARGET = Services.loadLazy(IMainPlatformTarget.class);
    public static final ICompat COMPAT = Services.load(ICompat.class);

    public static <T> T load(Class<T> clazz) {
        return ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
    }

    public static <T> ThreadsafeLazy<T> loadLazy(Class<T> clazz) {
        return new ThreadsafeLazy<Object>(() -> Services.load(clazz));
    }
}

