/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.excavated_variants.recipe;

import com.mojang.datafixers.util.Pair;
import io.github.lukebemish.excavated_variants.ExcavatedVariants;
import io.github.lukebemish.excavated_variants.platform.Services;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class OreConversionRecipe
extends CustomRecipe {
    public static final Map<ResourceLocation, ResourceLocation> oreMap = new HashMap<ResourceLocation, ResourceLocation>();
    public static Map<Item, Pair<ResourceLocation, Item>> itemMap;

    public OreConversionRecipe(ResourceLocation resourceLocation) {
        super(resourceLocation);
    }

    public static void assembleOrNull() {
        if (itemMap != null) {
            return;
        }
        itemMap = new HashMap<Item, Pair<ResourceLocation, Item>>();
        for (ResourceLocation rl : oreMap.keySet()) {
            Item itemIn = Services.REGISTRY_UTIL.getItemById(rl);
            Item itemOut = Services.REGISTRY_UTIL.getItemById(oreMap.get(rl));
            if (itemIn == null || itemOut == null) continue;
            itemMap.put(itemIn, (Pair<ResourceLocation, Item>)new Pair((Object)rl, (Object)itemOut));
        }
    }

    public boolean matches(CraftingContainer inv, Level level) {
        OreConversionRecipe.assembleOrNull();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack itemStack = inv.m_8020_(i);
            if (itemStack.m_41619_() || !itemMap.keySet().stream().anyMatch(arg_0 -> ((ItemStack)itemStack).m_150930_(arg_0))) continue;
            Item item = itemMap.keySet().stream().filter(arg_0 -> ((ItemStack)itemStack).m_150930_(arg_0)).toList().get(0);
            return item != null;
        }
        return false;
    }

    public ItemStack assemble(CraftingContainer inv) {
        OreConversionRecipe.assembleOrNull();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack itemStack = inv.m_8020_(i);
            if (itemStack.m_41619_() || !itemMap.keySet().stream().anyMatch(arg_0 -> ((ItemStack)itemStack).m_150930_(arg_0))) continue;
            Item item = itemMap.keySet().stream().filter(arg_0 -> ((ItemStack)itemStack).m_150930_(arg_0)).toList().get(0);
            return item == null ? null : new ItemStack((ItemLike)itemMap.get(item).getSecond());
        }
        return null;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 1 && height >= 1;
    }

    public RecipeSerializer<?> m_7707_() {
        return ExcavatedVariants.ORE_CONVERSION.get();
    }
}

