/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.logic;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.tr7zw.notenoughanimations.util.AnimationUtil;
import dev.tr7zw.notenoughanimations.util.MapRenderer;
import dev.tr7zw.notenoughanimations.util.NMSHelper;
import dev.tr7zw.notenoughanimations.versionless.NEABaseMod;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.EnchantTableRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class HeldItemHandler {
    private Item filledMap = NMSHelper.getItem(new ResourceLocation("minecraft", "filled_map"));
    private Item book = NMSHelper.getItem(new ResourceLocation("minecraft", "book"));
    private Item writtenBook = NMSHelper.getItem(new ResourceLocation("minecraft", "written_book"));
    private Item writableBook = NMSHelper.getItem(new ResourceLocation("minecraft", "writable_book"));
    private Item enchantedBook = NMSHelper.getItem(new ResourceLocation("minecraft", "enchanted_book"));
    private Item knowledgeBook = NMSHelper.getItem(new ResourceLocation("minecraft", "knowledge_book"));
    public Set<Item> books = new HashSet<Item>(Arrays.asList(this.writableBook, this.writtenBook, this.enchantedBook, this.knowledgeBook, this.book));
    public Map<Item, ResourceLocation> bookTextures = new HashMap<Item, ResourceLocation>(){
        {
            this.put(HeldItemHandler.this.knowledgeBook, new ResourceLocation("notenoughanimations", "textures/recipe_book.png"));
        }
    };
    public Set<Item> glintingBooks = new HashSet<Item>(Arrays.asList(this.enchantedBook));
    private BookModel bookModel = null;

    public void onRenderItem(LivingEntity entity, EntityModel<?> model, ItemStack itemStack, HumanoidArm arm, PoseStack matrices, MultiBufferSource vertexConsumers, int light, CallbackInfo info) {
        if (this.bookModel == null) {
            this.bookModel = new BookModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171271_));
        }
        if (entity.m_5803_()) {
            if (NEABaseMod.config.dontHoldItemsInBed) {
                info.cancel();
            }
            return;
        }
        if (itemStack.m_41782_() && itemStack.m_41783_().m_128441_("CustomModelData")) {
            return;
        }
        if (model instanceof ArmedModel && model instanceof HumanoidModel) {
            ArmedModel armedModel = (ArmedModel)model;
            HumanoidModel humanoid = (HumanoidModel)model;
            if (arm == HumanoidArm.RIGHT && humanoid.f_102811_.f_104207_ || arm == HumanoidArm.LEFT && humanoid.f_102812_.f_104207_) {
                if (NEABaseMod.config.enableInWorldMapRendering) {
                    if (arm == entity.m_5737_() && entity.m_21205_().m_41720_().equals(this.filledMap)) {
                        matrices.m_85836_();
                        armedModel.m_6002_(arm, matrices);
                        matrices.m_85845_(NMSHelper.XP.m_122240_(-90.0f));
                        matrices.m_85845_(NMSHelper.YP.m_122240_(200.0f));
                        boolean bl = arm == HumanoidArm.LEFT;
                        matrices.m_85837_((double)((float)(bl ? -1 : 1) / 16.0f), 0.125 + (entity.m_21206_().m_41619_() ? 0.15 : 0.0), -0.625);
                        MapRenderer.renderFirstPersonMap(matrices, vertexConsumers, light, itemStack, !entity.m_21206_().m_41619_(), entity.m_5737_() == HumanoidArm.LEFT);
                        matrices.m_85849_();
                        info.cancel();
                        return;
                    }
                    if (arm != entity.m_5737_() && entity.m_21206_().m_41720_().equals(this.filledMap)) {
                        matrices.m_85836_();
                        armedModel.m_6002_(arm, matrices);
                        matrices.m_85845_(NMSHelper.XP.m_122240_(-90.0f));
                        matrices.m_85845_(NMSHelper.YP.m_122240_(200.0f));
                        boolean bl = arm == HumanoidArm.LEFT;
                        matrices.m_85837_((double)((float)(bl ? -1 : 1) / 16.0f), 0.125, -0.625);
                        MapRenderer.renderFirstPersonMap(matrices, vertexConsumers, light, itemStack, true, false);
                        matrices.m_85849_();
                        info.cancel();
                        return;
                    }
                }
                if (NEABaseMod.config.enableInWorldBookRendering) {
                    Item item = entity.m_21205_().m_41720_();
                    if (arm == entity.m_5737_() && this.books.contains(item)) {
                        this.renderBook(entity, 0.0f, itemStack, arm, matrices, vertexConsumers, light, armedModel, this.glintingBooks.contains(item), item);
                        info.cancel();
                        return;
                    }
                    item = entity.m_21206_().m_41720_();
                    if (arm != entity.m_5737_() && this.books.contains(item)) {
                        this.renderBook(entity, 0.0f, itemStack, arm, matrices, vertexConsumers, light, armedModel, this.glintingBooks.contains(item), item);
                        info.cancel();
                        return;
                    }
                }
            }
        }
        if (NEABaseMod.config.enableOffhandHiding && entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            HumanoidModel.ArmPose armPose = AnimationUtil.getArmPose(player, InteractionHand.MAIN_HAND);
            HumanoidModel.ArmPose armPose2 = AnimationUtil.getArmPose(player, InteractionHand.OFF_HAND);
            if (!AnimationUtil.isUsingboothHands(armPose) && !AnimationUtil.isUsingboothHands(armPose2)) {
                return;
            }
            if (armPose.m_102897_()) {
                HumanoidModel.ArmPose armPose3 = armPose2 = player.m_21206_().m_41619_() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
            }
            if (player.m_5737_() == HumanoidArm.RIGHT) {
                if (arm == HumanoidArm.RIGHT && AnimationUtil.isUsingboothHands(armPose2)) {
                    info.cancel();
                    return;
                }
                if (arm == HumanoidArm.LEFT && AnimationUtil.isUsingboothHands(armPose)) {
                    info.cancel();
                    return;
                }
            } else {
                if (arm == HumanoidArm.LEFT && AnimationUtil.isUsingboothHands(armPose2)) {
                    info.cancel();
                    return;
                }
                if (arm == HumanoidArm.RIGHT && AnimationUtil.isUsingboothHands(armPose)) {
                    info.cancel();
                    return;
                }
            }
        }
    }

    private void renderBook(LivingEntity entity, float delta, ItemStack itemStack, HumanoidArm arm, PoseStack matrices, MultiBufferSource vertexConsumers, int light, ArmedModel armedModel, boolean glow, Item item) {
        matrices.m_85836_();
        armedModel.m_6002_(arm, matrices);
        matrices.m_85845_(NMSHelper.YP.m_122240_(100.0f));
        matrices.m_85845_(NMSHelper.ZP.m_122240_(-100.0f));
        matrices.m_85837_(-0.56, 0.34, 0.0);
        float g = (float)entity.f_19797_ + delta;
        float l = 0.0f;
        float m = Mth.m_14187_((float)(l + 0.25f)) * 1.6f - 0.3f;
        float n = Mth.m_14187_((float)(l + 0.75f)) * 1.6f - 0.3f;
        float o = 1.0f;
        this.bookModel.m_102292_(g, Mth.m_14036_((float)m, (float)0.0f, (float)1.0f), Mth.m_14036_((float)n, (float)0.0f, (float)1.0f), o);
        VertexConsumer vertexConsumer = this.bookTextures.containsKey(item) ? ItemRenderer.m_115222_((MultiBufferSource)vertexConsumers, (RenderType)RenderType.m_110446_((ResourceLocation)this.bookTextures.get(item)), (boolean)true, (boolean)glow) : EnchantTableRenderer.f_112405_.m_119197_(vertexConsumers, RenderType::m_110446_, glow);
        this.bookModel.m_102316_(matrices, vertexConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrices.m_85849_();
        if (item == this.writtenBook) {
            matrices.m_85836_();
            armedModel.m_6002_(arm, matrices);
            this.renderText(entity, matrices, itemStack, armedModel, arm);
            matrices.m_85849_();
        }
    }

    private void renderText(LivingEntity entity, PoseStack matrices, ItemStack itemStack, ArmedModel armedModel, HumanoidArm arm) {
    }

    private BookViewScreen.BookAccess fromItem(ItemStack itemStack) {
        if (itemStack.m_150930_(Items.f_42615_)) {
            return new BookViewScreen.WrittenBookAccess(itemStack);
        }
        if (itemStack.m_150930_(Items.f_42614_)) {
            return new BookViewScreen.WritableBookAccess(itemStack);
        }
        return BookViewScreen.f_98251_;
    }
}

