/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.block;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import vazkii.arl.interf.IBlockColorProvider;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.handler.CreativeTabHandler;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.building.module.HedgesModule;
import vazkii.quark.content.world.block.BlossomLeavesBlock;

public class HedgeBlock
extends FenceBlock
implements IQuarkBlock,
IBlockColorProvider {
    private static final VoxelShape WOOD_SHAPE = HedgeBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)15.0, (double)10.0);
    private static final VoxelShape HEDGE_CENTER_SHAPE = HedgeBlock.m_49796_((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape NORTH_SHAPE = HedgeBlock.m_49796_((double)2.0, (double)1.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0);
    private static final VoxelShape SOUTH_SHAPE = HedgeBlock.m_49796_((double)2.0, (double)1.0, (double)14.0, (double)14.0, (double)16.0, (double)15.0);
    private static final VoxelShape EAST_SHAPE = HedgeBlock.m_49796_((double)14.0, (double)1.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0);
    private static final VoxelShape WEST_SHAPE = HedgeBlock.m_49796_((double)0.0, (double)1.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0);
    private static final VoxelShape EXTEND_SHAPE = HedgeBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0);
    private final Object2IntMap<BlockState> hedgeStateToIndex;
    private final VoxelShape[] hedgeShapes;
    private final QuarkModule module;
    private final Block leaf;
    private BooleanSupplier enabledSupplier = () -> true;
    public static final BooleanProperty EXTEND = BooleanProperty.m_61465_((String)"extend");

    public HedgeBlock(QuarkModule module, Block fence, Block leaf) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)fence));
        this.module = module;
        this.leaf = leaf;
        ResourceLocation leafRes = RegistryHelper.getRegistryName((Object)leaf, (Registry)Registry.f_122824_);
        if (leaf instanceof BlossomLeavesBlock) {
            String colorName = leafRes.m_135815_().replaceAll("_blossom_leaves", "");
            RegistryHelper.registerBlock((Block)this, (String)(colorName + "_blossom_hedge"));
        } else {
            RegistryHelper.registerBlock((Block)this, (String)leafRes.m_135815_().replaceAll("_leaves", "_hedge"));
        }
        CreativeTabHandler.addTab(this, CreativeModeTab.f_40750_);
        RenderLayerHandler.setRenderType((Block)this, RenderLayerHandler.RenderTypeSkeleton.CUTOUT);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)EXTEND, (Comparable)Boolean.valueOf(false)));
        this.hedgeStateToIndex = new Object2IntOpenHashMap();
        this.hedgeShapes = this.cacheHedgeShapes((ImmutableList<BlockState>)this.f_49792_.m_61056_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.hedgeShapes[this.getHedgeAABBIndex(state)];
    }

    private VoxelShape[] cacheHedgeShapes(ImmutableList<BlockState> possibleStates) {
        VoxelShape[] shapes = new VoxelShape[possibleStates.size()];
        for (int i = 0; i < shapes.length; ++i) {
            BlockState state = (BlockState)possibleStates.get(i);
            int realIndex = this.getHedgeAABBIndex(state);
            VoxelShape finishedShape = Shapes.m_83110_((VoxelShape)((Boolean)state.m_61143_((Property)EXTEND) != false ? EXTEND_SHAPE : WOOD_SHAPE), (VoxelShape)HEDGE_CENTER_SHAPE);
            if (((Boolean)state.m_61143_((Property)FenceBlock.f_52309_)).booleanValue()) {
                finishedShape = Shapes.m_83110_((VoxelShape)finishedShape, (VoxelShape)NORTH_SHAPE);
            }
            if (((Boolean)state.m_61143_((Property)FenceBlock.f_52311_)).booleanValue()) {
                finishedShape = Shapes.m_83110_((VoxelShape)finishedShape, (VoxelShape)SOUTH_SHAPE);
            }
            if (((Boolean)state.m_61143_((Property)FenceBlock.f_52310_)).booleanValue()) {
                finishedShape = Shapes.m_83110_((VoxelShape)finishedShape, (VoxelShape)EAST_SHAPE);
            }
            if (((Boolean)state.m_61143_((Property)FenceBlock.f_52312_)).booleanValue()) {
                finishedShape = Shapes.m_83110_((VoxelShape)finishedShape, (VoxelShape)WEST_SHAPE);
            }
            shapes[realIndex] = finishedShape;
        }
        return shapes;
    }

    protected int getHedgeAABBIndex(BlockState curr) {
        return this.hedgeStateToIndex.computeIntIfAbsent((Object)curr, state -> {
            int i = 0;
            if (((Boolean)state.m_61143_((Property)FenceBlock.f_52309_)).booleanValue()) {
                i |= 1;
            }
            if (((Boolean)state.m_61143_((Property)FenceBlock.f_52311_)).booleanValue()) {
                i |= 2;
            }
            if (((Boolean)state.m_61143_((Property)FenceBlock.f_52310_)).booleanValue()) {
                i |= 4;
            }
            if (((Boolean)state.m_61143_((Property)FenceBlock.f_52312_)).booleanValue()) {
                i |= 8;
            }
            if (((Boolean)state.m_61143_((Property)EXTEND)).booleanValue()) {
                i |= 0x10;
            }
            return i;
        });
    }

    public boolean m_53329_(BlockState state, boolean isSideSolid, @Nonnull Direction direction) {
        return state.m_204336_(HedgesModule.hedgesTag);
    }

    public boolean canSustainPlant(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull Direction facing, @Nonnull IPlantable plantable) {
        return facing == Direction.UP && (Boolean)state.m_61143_((Property)f_52313_) == false && plantable.getPlantType(world, pos) == PlantType.PLAINS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level iblockreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        BlockPos down = blockpos.m_7495_();
        BlockState downState = iblockreader.m_8055_(down);
        return (BlockState)super.m_5573_(context).m_61124_((Property)EXTEND, (Comparable)Boolean.valueOf(downState.m_60734_() instanceof HedgeBlock));
    }

    @Nonnull
    public BlockState m_7417_(BlockState stateIn, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor worldIn, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)f_52313_)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        if (facing == Direction.DOWN) {
            return (BlockState)stateIn.m_61124_((Property)EXTEND, (Comparable)Boolean.valueOf(facingState.m_60734_() instanceof HedgeBlock));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{EXTEND});
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockColor getBlockColor() {
        BlockState leafState = this.leaf.m_49966_();
        return (state, world, pos, tintIndex) -> Minecraft.m_91087_().m_91298_().m_92577_(leafState, world, pos, tintIndex);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemColor getItemColor() {
        ItemStack leafStack = new ItemStack((ItemLike)this.leaf);
        return (stack, tintIndex) -> Minecraft.m_91087_().getItemColors().m_92676_(leafStack, tintIndex);
    }

    public void m_49811_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.isEnabled() || group == CreativeModeTab.f_40754_) {
            super.m_49811_(group, items);
        }
    }

    @Override
    public QuarkModule getModule() {
        return this.module;
    }

    @Override
    public HedgeBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }
}

