/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.module;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.handler.StructureBlockReplacementHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.util.VanillaWoods;
import vazkii.quark.content.building.block.VariantChestBlock;
import vazkii.quark.content.building.block.VariantTrappedChestBlock;
import vazkii.quark.content.building.block.be.VariantChestBlockEntity;
import vazkii.quark.content.building.block.be.VariantTrappedChestBlockEntity;
import vazkii.quark.content.building.client.render.be.VariantChestRenderer;
import vazkii.quark.content.building.recipe.MixedExclusionRecipe;
import vazkii.quark.integration.lootr.ILootrIntegration;
import vazkii.quark.mixin.accessor.AccessorAbstractChestedHorse;

@LoadModule(category=ModuleCategory.BUILDING, hasSubscriptions=true, antiOverlap={"woodworks"})
public class VariantChestsModule
extends QuarkModule {
    private static final String DONK_CHEST = "Quark:DonkChest";
    private static final ImmutableSet<VanillaWoods.Wood> VANILLA_WOODS = ImmutableSet.copyOf((Object[])VanillaWoods.ALL);
    private static final ImmutableSet<String> MOD_WOODS = ImmutableSet.of();
    public static BlockEntityType<VariantChestBlockEntity> chestTEType;
    public static BlockEntityType<VariantTrappedChestBlockEntity> trappedChestTEType;
    private static final List<ChestInfo> chestTypes;
    private static final Map<ChestInfo, TagKey<Structure>> structureTags;
    public static final List<Block> chests;
    public static final List<Block> trappedChests;
    private static final List<Block> allChests;
    private static final Map<ResourceLocation, Block> manualChestMappings;
    private static final Map<ResourceLocation, Block> manualTrappedChestMappings;
    private static final Map<TagKey<Structure>, Block> chestMappings;
    private static final Map<TagKey<Structure>, Block> trappedChestMappings;
    @Config
    private static boolean replaceWorldgenChests;
    @Config(flag="chest_reversion")
    private static boolean enableRevertingWoodenChests;
    private static boolean staticEnabled;
    @Config(description="Chests to put in structures. It's preferred to use worldgen tags for this. The format per entry is \"structure=chest\", where \"structure\" is a structure ID, and \"chest\" is a block ID, which must correspond to a standard chest block.")
    public static List<String> structureChests;
    private static final ThreadLocal<ItemStack> WAIT_TO_REPLACE_CHEST;

    @Override
    public void register() {
        ForgeRegistries.RECIPE_SERIALIZERS.register("quark:mixed_exclusion", (Object)MixedExclusionRecipe.SERIALIZER);
        VANILLA_WOODS.forEach(s -> this.addChest(s.name(), Blocks.f_50087_));
        MOD_WOODS.forEach(s -> this.addModChest((String)s, Blocks.f_50087_));
        this.addChest("nether_brick", Blocks.f_50197_);
        this.addChest("purpur", Blocks.f_50492_);
        this.addChest("prismarine", Blocks.f_50377_);
        StructureBlockReplacementHandler.addReplacement(VariantChestsModule::getGenerationChestBlockState);
    }

    @Override
    public void postRegister() {
        Consumer[] consumerArray = new Consumer[2];
        consumerArray[0] = allChests::addAll;
        consumerArray[1] = chests::addAll;
        chestTEType = VariantChestsModule.registerChests(VariantChestBlockEntity::new, () -> chestTEType, VariantChestBlock::new, VariantChestBlock.Compat::new, chestMappings, consumerArray);
        Consumer[] consumerArray2 = new Consumer[2];
        consumerArray2[0] = allChests::addAll;
        consumerArray2[1] = trappedChests::addAll;
        trappedChestTEType = VariantChestsModule.registerChests(VariantTrappedChestBlockEntity::new, () -> trappedChestTEType, VariantTrappedChestBlock::new, VariantTrappedChestBlock.Compat::new, trappedChestMappings, consumerArray2);
        RegistryHelper.register(chestTEType, (String)"variant_chest", (ResourceKey)Registry.f_122907_);
        RegistryHelper.register(trappedChestTEType, (String)"variant_trapped_chest", (ResourceKey)Registry.f_122907_);
        ILootrIntegration.INSTANCE.postRegister();
    }

    @Override
    public void loadComplete() {
        ILootrIntegration.INSTANCE.loadComplete();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        BlockEntityRenderers.m_173590_(chestTEType, VariantChestRenderer::new);
        BlockEntityRenderers.m_173590_(trappedChestTEType, VariantChestRenderer::new);
        ILootrIntegration.INSTANCE.clientSetup();
    }

    @Override
    public void configChanged() {
        super.configChanged();
        staticEnabled = this.enabled;
        manualChestMappings.clear();
        manualTrappedChestMappings.clear();
        ArrayList<String> chestsClone = new ArrayList<String>(structureChests);
        for (String s : chestsClone) {
            String[] toks = s.split("=");
            if (toks.length != 2) continue;
            String left = toks[0];
            String right = toks[1];
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(right));
            if (block == null || block == Blocks.f_50016_) continue;
            manualChestMappings.put(new ResourceLocation(left), block);
            if (!chests.contains(block)) continue;
            Block trapped = trappedChests.get(chests.indexOf(block));
            manualTrappedChestMappings.put(new ResourceLocation(left), trapped);
        }
    }

    private static BlockState getGenerationChestBlockState(ServerLevelAccessor accessor, BlockState current, StructureBlockReplacementHandler.StructureHolder structure) {
        if (staticEnabled && replaceWorldgenChests) {
            if (current.m_60734_() == Blocks.f_50087_) {
                return VariantChestsModule.replaceChestState(accessor, current, structure, chestMappings, manualChestMappings);
            }
            if (current.m_60734_() == Blocks.f_50325_) {
                return VariantChestsModule.replaceChestState(accessor, current, structure, trappedChestMappings, manualTrappedChestMappings);
            }
        }
        return null;
    }

    @Nullable
    private static BlockState replaceChestState(ServerLevelAccessor accessor, BlockState current, StructureBlockReplacementHandler.StructureHolder structure, Map<TagKey<Structure>, Block> mappings, Map<ResourceLocation, Block> manualMappings) {
        Holder<Structure> structureHolder = StructureBlockReplacementHandler.getStructure(accessor, structure);
        if (structureHolder != null) {
            for (TagKey<Structure> structureTagKey : mappings.keySet()) {
                if (!structureHolder.m_203656_(structureTagKey)) continue;
                Block block = mappings.get(structureTagKey);
                return block.m_152465_(current);
            }
            Optional<Block> manualMapping = structureHolder.m_203543_().map(ResourceKey::m_135782_).map(manualMappings::get);
            if (manualMapping.isPresent()) {
                return manualMapping.get().m_152465_(current);
            }
        }
        return null;
    }

    private void addChest(String name, Block from) {
        this.addChest(name, () -> BlockBehaviour.Properties.m_60926_((BlockBehaviour)from));
    }

    public void addChest(String name, Supplier<BlockBehaviour.Properties> props) {
        VariantChestsModule.addChest(name, this, props, false);
    }

    public static void addChest(String name, QuarkModule module, Supplier<BlockBehaviour.Properties> props, boolean external) {
        BooleanSupplier cond = external ? () -> ModuleLoader.INSTANCE.isModuleEnabled(VariantChestsModule.class) : () -> true;
        chestTypes.add(new ChestInfo(name, module, props, cond, null));
    }

    private void addModChest(String nameRaw, Block from) {
        String[] toks = nameRaw.split(":");
        String name = toks[1];
        String mod = toks[0];
        this.addModChest(name, mod, () -> BlockBehaviour.Properties.m_60926_((BlockBehaviour)from));
    }

    private void addModChest(String name, String mod, Supplier<BlockBehaviour.Properties> props) {
        chestTypes.add(new ChestInfo(name, this, props, null, mod));
    }

    @SafeVarargs
    public static <T extends BlockEntity> BlockEntityType<T> registerChests(BlockEntityType.BlockEntitySupplier<? extends T> factory, Supplier<BlockEntityType<? extends ChestBlockEntity>> tileType, ChestConstructor chestType, CompatChestConstructor compatType, @Nullable Map<TagKey<Structure>, Block> structureMappings, Consumer<List<Block>> ... toStitch) {
        List<Block> blockTypes = chestTypes.stream().map(it -> {
            Block block;
            Block block2 = block = it.mod != null ? compatType.createChest(it.type, it.mod, it.module, tileType, it.props.get()) : chestType.createChest(it.type, it.module, tileType, it.props.get());
            if (it.condition != null && block instanceof IQuarkBlock) {
                IQuarkBlock quarkBlock = (IQuarkBlock)block;
                quarkBlock.setCondition(it.condition);
            }
            if (structureMappings != null) {
                TagKey tag = structureTags.computeIfAbsent((ChestInfo)it, info -> TagKey.m_203882_((ResourceKey)Registry.f_235725_, (ResourceLocation)new ResourceLocation("quark", info.type + "_chest_structures")));
                structureMappings.put(tag, block);
            }
            return block;
        }).toList();
        for (Consumer<List<Block>> consumer : toStitch) {
            consumer.accept(blockTypes);
        }
        return BlockEntityType.Builder.m_155273_(factory, (Block[])blockTypes.toArray(new Block[0])).m_58966_(null);
    }

    @Override
    public void textureStitch(TextureStitchEvent.Pre event) {
        if (event.getAtlas().m_118330_().toString().equals("minecraft:textures/atlas/chest.png")) {
            for (Block b : allChests) {
                VariantChestRenderer.accept(event, b);
            }
            ILootrIntegration.INSTANCE.stitch(event);
        }
    }

    @SubscribeEvent
    public void onClickEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        AbstractChestedHorse horse;
        Entity target = event.getTarget();
        Player player = event.getEntity();
        ItemStack held = player.m_21120_(event.getHand());
        if (!held.m_41619_() && target instanceof AbstractChestedHorse && !(horse = (AbstractChestedHorse)target).m_30502_() && held.m_41720_() != Items.f_42009_ && held.m_204117_(Tags.Items.CHESTS_WOODEN)) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            if (!target.f_19853_.f_46443_) {
                ItemStack copy = held.m_41777_();
                copy.m_41764_(1);
                held.m_41774_(1);
                horse.getPersistentData().m_128365_(DONK_CHEST, (Tag)copy.serializeNBT());
                horse.m_30504_(true);
                horse.m_30625_();
                ((AccessorAbstractChestedHorse)horse).quark$playChestEquipsSound();
            }
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        AbstractChestedHorse horse;
        ItemStack chest;
        LivingEntity target = event.getEntity();
        if (target instanceof AbstractChestedHorse && !(chest = ItemStack.m_41712_((CompoundTag)(horse = (AbstractChestedHorse)target).getPersistentData().m_128469_(DONK_CHEST))).m_41619_() && horse.m_30502_()) {
            WAIT_TO_REPLACE_CHEST.set(chest);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinLevelEvent event) {
        ItemEntity item;
        Entity target = event.getEntity();
        if (target instanceof ItemEntity && (item = (ItemEntity)target).m_32055_().m_41720_() == Items.f_42009_) {
            ItemStack local = WAIT_TO_REPLACE_CHEST.get();
            if (local != null && !local.m_41619_()) {
                ((ItemEntity)target).m_32045_(local);
            }
            WAIT_TO_REPLACE_CHEST.remove();
        }
    }

    static {
        chestTypes = new LinkedList<ChestInfo>();
        structureTags = new HashMap<ChestInfo, TagKey<Structure>>();
        chests = new LinkedList<Block>();
        trappedChests = new LinkedList<Block>();
        allChests = new LinkedList<Block>();
        manualChestMappings = new HashMap<ResourceLocation, Block>();
        manualTrappedChestMappings = new HashMap<ResourceLocation, Block>();
        chestMappings = new HashMap<TagKey<Structure>, Block>();
        trappedChestMappings = new HashMap<TagKey<Structure>, Block>();
        replaceWorldgenChests = true;
        enableRevertingWoodenChests = true;
        staticEnabled = false;
        structureChests = new ArrayList<String>();
        WAIT_TO_REPLACE_CHEST = new ThreadLocal();
    }

    @FunctionalInterface
    public static interface ChestConstructor {
        public Block createChest(String var1, QuarkModule var2, Supplier<BlockEntityType<? extends ChestBlockEntity>> var3, BlockBehaviour.Properties var4);
    }

    @FunctionalInterface
    public static interface CompatChestConstructor {
        public Block createChest(String var1, String var2, QuarkModule var3, Supplier<BlockEntityType<? extends ChestBlockEntity>> var4, BlockBehaviour.Properties var5);
    }

    private record ChestInfo(String type, QuarkModule module, Supplier<BlockBehaviour.Properties> props, @Nullable BooleanSupplier condition, @Nullable String mod) {
    }

    public static interface IChestTextureProvider {
        public String getChestTexturePath();

        public boolean isTrap();
    }
}

