/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.eatinganimation.pack;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.matyrobbrt.eatinganimation.EatingAnimation;
import com.matyrobbrt.eatinganimation.datagen.ItemModelGenerator;
import com.mojang.bridge.game.GameVersion;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.SharedConstants;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackType;
import org.apache.commons.io.IOUtils;

public final class ModCompatResourcePack
extends AbstractPackResources {
    public static final Gson GSON = new Gson();
    public static final int NUMBER_OF_MODELS = 3;
    private final String namespace;
    private final Set<String> namespaces;
    private final Set<String> itemNames;
    private final Map<String, IOSupplier> resources = new HashMap<String, IOSupplier>();
    private final byte[] packMcMeta;

    public ModCompatResourcePack(Path path, String namespace) {
        super(new File("dummy"));
        this.namespace = namespace;
        this.namespaces = Set.of("eatinganimation", namespace);
        this.itemNames = ModCompatResourcePack.collectNames(path, namespace);
        for (String name : this.itemNames) {
            Path propsFile = path.resolve(name).resolve("properties.json");
            Properties props = null;
            if (Files.exists(propsFile, new LinkOption[0])) {
                props = ModCompatResourcePack.readProps(propsFile);
            }
            if (props == null) {
                props = new Properties();
            }
            String itemModel = ItemModelGenerator.generateItemModel(name, namespace, props.resolveModel(namespace + ":item/" + name), props.values);
            this.resources.put("assets/" + namespace + "/models/item/" + name + ".json", () -> ModCompatResourcePack.toIs(itemModel));
            for (int i = 0; i < 3; ++i) {
                Path fullPath = path.resolve(name).resolve(i + ".png");
                this.resources.put("assets/eatinganimation/textures/item/" + namespace + "/" + name + "_" + i + ".png", () -> Files.newInputStream(fullPath, new OpenOption[0]));
                String animation = ItemModelGenerator.generateAnimationModel(name, namespace, i);
                this.resources.put("assets/eatinganimation/models/item/" + namespace + "/" + name + "_" + i + ".json", () -> ModCompatResourcePack.toIs(animation));
            }
        }
        this.packMcMeta = "{\"pack\":{\"description\":\"EatingAnimations %s compatibility\",\"pack_format\":%s}}".formatted(namespace, PackType.CLIENT_RESOURCES.m_143756_((GameVersion)SharedConstants.m_183709_())).getBytes(StandardCharsets.UTF_8);
    }

    private static ByteArrayInputStream toIs(String str) {
        return new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));
    }

    private static Properties readProps(Path path) {
        Properties properties;
        block8: {
            InputStream is = Files.newInputStream(path, new OpenOption[0]);
            try {
                String str = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                properties = (Properties)GSON.fromJson(str, Properties.class);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    EatingAnimation.LOGGER.error("Exception trying to read model properties file: {}", (Throwable)e);
                    return null;
                }
            }
            is.close();
        }
        return properties;
    }

    private static Set<String> collectNames(Path path, final String namespace) {
        final HashSet<String> names = new HashSet<String>();
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    String name = dir.getFileName().toString();
                    if (!name.equals(namespace)) {
                        names.add(name);
                    }
                    return super.postVisitDirectory(dir, exc);
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return names;
    }

    public Collection<ResourceLocation> m_214146_(PackType type, String resourceNamespace, String pathIn, Predicate<ResourceLocation> p_215342_) {
        if (type != PackType.CLIENT_RESOURCES || !resourceNamespace.equals("eatinganimation") || !resourceNamespace.equals(this.namespace)) {
            return Collections.emptyList();
        }
        return this.itemNames.stream().flatMap(name -> {
            HashSet<ResourceLocation> locations = new HashSet<ResourceLocation>();
            if (resourceNamespace.equals(this.namespace)) {
                locations.add(new ResourceLocation(this.namespace, "models/item/" + name + ".json"));
            } else {
                for (int i = 0; i < 3; ++i) {
                    locations.add(new ResourceLocation(resourceNamespace, "textures/item/" + this.namespace + "/" + name + "_" + i + ".png"));
                    locations.add(new ResourceLocation(resourceNamespace, "models/item/" + this.namespace + "/" + name + "_" + i + ".json"));
                }
            }
            return locations.stream();
        }).filter(p_215342_).toList();
    }

    public Set<String> m_5698_(PackType p_10283_) {
        return p_10283_ == PackType.CLIENT_RESOURCES ? this.namespaces : Set.of();
    }

    public void close() {
    }

    protected InputStream m_5541_(String p_10220_) throws IOException {
        if (p_10220_.equals("pack.mcmeta")) {
            return new ByteArrayInputStream(this.packMcMeta);
        }
        IOSupplier res = this.resources.get(p_10220_);
        return res == null ? null : res.get();
    }

    protected boolean m_6105_(String name) {
        return this.resources.containsKey(name);
    }

    public String m_8017_() {
        return "Eating Animations " + this.namespace + " compatibility";
    }

    public String toString() {
        return ((Object)((Object)this)).getClass() + "/" + this.m_8017_();
    }

    public final class Properties {
        @SerializedName(value="layer0")
        public String defaultModel;
        public float[] values = new float[]{0.35f, 0.7f, 0.9f};

        public String resolveModel(String fallback) {
            return this.defaultModel == null ? fallback : this.defaultModel;
        }
    }

    static interface IOSupplier {
        public InputStream get() throws IOException;
    }
}

