/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.crafting;

import com.hidoni.customizableelytra.setup.ModItems;
import com.hidoni.customizableelytra.setup.ModRecipes;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ElytraWingCombinationRecipe
extends CustomRecipe {
    public ElytraWingCombinationRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        ItemStack leftWing = ItemStack.f_41583_;
        ItemStack rightWing = ItemStack.f_41583_;
        boolean isEnchanted = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack inventoryItem = inv.m_8020_(i);
            if (inventoryItem.m_41619_() || inventoryItem.m_41720_() != ModItems.ELYTRA_WING.get()) continue;
            if (leftWing == ItemStack.f_41583_) {
                leftWing = inventoryItem;
                isEnchanted = !EnchantmentHelper.m_44831_((ItemStack)inventoryItem).isEmpty();
                continue;
            }
            if (rightWing == ItemStack.f_41583_ && (!isEnchanted || EnchantmentHelper.m_44831_((ItemStack)inventoryItem).isEmpty())) {
                rightWing = inventoryItem;
                continue;
            }
            return false;
        }
        return !leftWing.m_41619_() && !rightWing.m_41619_();
    }

    public ItemStack assemble(CraftingContainer inv) {
        ItemStack leftWing = ItemStack.f_41583_;
        ItemStack rightWing = ItemStack.f_41583_;
        boolean isEnchanted = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack inventoryItem = inv.m_8020_(i);
            if (inventoryItem.m_41619_() || inventoryItem.m_41720_() != ModItems.ELYTRA_WING.get()) continue;
            if (leftWing == ItemStack.f_41583_) {
                leftWing = inventoryItem;
                isEnchanted = !EnchantmentHelper.m_44831_((ItemStack)inventoryItem).isEmpty();
                continue;
            }
            if (rightWing == ItemStack.f_41583_ && (!isEnchanted || EnchantmentHelper.m_44831_((ItemStack)inventoryItem).isEmpty())) {
                rightWing = inventoryItem;
                continue;
            }
            return ItemStack.f_41583_;
        }
        ItemStack customizedElytra = new ItemStack((ItemLike)ModItems.CUSTOMIZABLE_ELYTRA.get());
        customizedElytra.m_41721_((leftWing.m_41773_() + rightWing.m_41773_()) / 2);
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)leftWing);
        if (enchantments.isEmpty()) {
            enchantments = EnchantmentHelper.m_44831_((ItemStack)rightWing);
        }
        EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)customizedElytra);
        customizedElytra.m_41742_(Math.max(leftWing.m_41610_(), rightWing.m_41610_()));
        if (leftWing.m_41788_()) {
            customizedElytra.m_41714_(leftWing.m_41786_());
        } else if (rightWing.m_41788_()) {
            customizedElytra.m_41714_(rightWing.m_41786_());
        }
        CompoundTag leftWingNBT = this.convertWingToNBT(leftWing);
        CompoundTag rightWingNBT = this.convertWingToNBT(rightWing);
        CompoundTag wingInfo = new CompoundTag();
        if (leftWingNBT != null) {
            wingInfo.m_128365_("left", (Tag)leftWingNBT);
        }
        if (rightWingNBT != null) {
            wingInfo.m_128365_("right", (Tag)rightWingNBT);
        }
        customizedElytra.m_41700_("WingInfo", (Tag)wingInfo);
        return customizedElytra;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.ELYTRA_WING_COMBINATION_RECIPE.get();
    }

    public CompoundTag convertWingToNBT(ItemStack wingIn) {
        return wingIn.m_41784_();
    }
}

