/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.nohostilesaroundcampfire_common_fabric.events;

import com.natamus.collective_common_fabric.functions.CompareBlockFunctions;
import com.natamus.collective_common_fabric.functions.EntityFunctions;
import com.natamus.collective_common_fabric.functions.FABFunctions;
import com.natamus.collective_common_fabric.functions.HashMapFunctions;
import com.natamus.nohostilesaroundcampfire_common_fabric.config.ConfigHandler;
import com.natamus.nohostilesaroundcampfire_common_fabric.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1786;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3730;
import net.minecraft.class_3922;
import net.minecraft.class_3965;
import net.minecraft.class_6862;

public class CampfireEvent {
    private static final HashMap<class_1937, List<class_2338>> checkCampfireBurn = new HashMap();

    public static void onWorldTick(class_3218 level) {
        if (((List)HashMapFunctions.computeIfAbsent(checkCampfireBurn, (Object)level, k -> new ArrayList())).size() > 0) {
            class_2338 campfirepos = checkCampfireBurn.get(level).get(0);
            class_2680 campfirestate = level.method_8320(campfirepos);
            if (CompareBlockFunctions.blockIsInRegistryHolder((class_2248)campfirestate.method_26204(), (class_6862)class_3481.field_23799)) {
                boolean islit = true;
                if (ConfigHandler.campfireMustBeLit) {
                    islit = (Boolean)campfirestate.method_11654((class_2769)class_3922.field_17352);
                }
                if (islit) {
                    int r = (int)((double)ConfigHandler.preventHostilesRadius * ConfigHandler.burnHostilesRadiusModifier);
                    List entities = level.method_8335(null, new class_238((double)(campfirepos.method_10263() - r), (double)(campfirepos.method_10264() - r), (double)(campfirepos.method_10260() - r), (double)(campfirepos.method_10263() + r), (double)(campfirepos.method_10264() + r), (double)(campfirepos.method_10260() + r)));
                    for (class_1297 entity : entities) {
                        if (!Util.entityIsHostile(entity)) continue;
                        entity.method_5639(30);
                    }
                }
            }
            checkCampfireBurn.get(level).remove(0);
        }
    }

    public static boolean onEntityCheckSpawn(class_1308 entity, class_3218 world, class_2338 spawnerPos, class_3730 spawnReason) {
        if (entity == null) {
            return true;
        }
        if (entity.method_5752().contains("nohostilesaroundcampfire.checked")) {
            return true;
        }
        entity.method_5780("nohostilesaroundcampfire.checked");
        if (!ConfigHandler.preventMobSpawnerSpawns && EntityFunctions.isEntityFromSpawner((class_1297)entity).booleanValue()) {
            return true;
        }
        if (!Util.entityIsHostile((class_1297)entity)) {
            return true;
        }
        List nearbycampfires = FABFunctions.getAllTaggedTileEntityPositionsNearbyEntity((class_6862)class_3481.field_23799, (Integer)ConfigHandler.preventHostilesRadius, (class_1937)world, (class_1297)entity);
        if (nearbycampfires.size() == 0) {
            return true;
        }
        class_2338 campfire = null;
        for (class_2338 nearbycampfire : nearbycampfires) {
            Boolean issignalling;
            Boolean islit;
            class_2680 campfirestate = world.method_8320(nearbycampfire);
            class_2248 block = campfirestate.method_26204();
            if (!(block instanceof class_3922) || !ConfigHandler.enableEffectForNormalCampfires && block.equals(class_2246.field_17350) || !ConfigHandler.enableEffectForSoulCampfires && block.equals(class_2246.field_23860) || ConfigHandler.campfireMustBeLit && !(islit = (Boolean)campfirestate.method_11654((class_2769)class_3922.field_17352)).booleanValue() || ConfigHandler.campfireMustBeSignalling && !(issignalling = (Boolean)campfirestate.method_11654((class_2769)class_3922.field_17353)).booleanValue()) continue;
            campfire = nearbycampfire.method_10062();
            break;
        }
        if (campfire == null) {
            return true;
        }
        List passengers = entity.method_5685();
        if (passengers.size() > 0) {
            for (class_1297 passenger : passengers) {
                passenger.method_5650(class_1297.class_5529.field_26999);
            }
        }
        return false;
    }

    public static void onCampfirePlace(class_1937 level, class_2338 blockPos, class_2680 blockState, class_1309 livingEntity, class_1799 itemStack) {
        if (level.field_9236) {
            return;
        }
        if (!ConfigHandler.burnHostilesAroundWhenPlaced) {
            return;
        }
        class_2248 block = blockState.method_26204();
        if (!CompareBlockFunctions.blockIsInRegistryHolder((class_2248)block, (class_6862)class_3481.field_23799)) {
            return;
        }
        if (!ConfigHandler.enableEffectForNormalCampfires && block.equals(class_2246.field_17350)) {
            return;
        }
        if (!ConfigHandler.enableEffectForSoulCampfires && block.equals(class_2246.field_23860)) {
            return;
        }
        ((List)HashMapFunctions.computeIfAbsent(checkCampfireBurn, (Object)level, k -> new ArrayList())).add(blockPos.method_10062());
    }

    public static boolean onRightClickCampfireBlock(class_1937 level, class_1657 player, class_1268 hand, class_2338 pos, class_3965 hitVec) {
        if (level.field_9236) {
            return true;
        }
        class_2680 state = level.method_8320(pos);
        class_2248 block = state.method_26204();
        if (CompareBlockFunctions.blockIsInRegistryHolder((class_2248)block, (class_6862)class_3481.field_23799)) {
            if (((Boolean)state.method_11654((class_2769)class_3922.field_17352)).booleanValue()) {
                return true;
            }
            if (player.method_6047().method_7909() instanceof class_1786 || player.method_6079().method_7909() instanceof class_1786) {
                ((List)HashMapFunctions.computeIfAbsent(checkCampfireBurn, (Object)level, k -> new ArrayList())).add(pos.method_10062());
            }
        }
        return true;
    }

    public static void onCampfireBreak(class_1937 world, class_1657 player, class_2338 ppos, class_2680 blockState, class_2586 blockEntity, class_1799 itemStack) {
        if (world.field_9236) {
            return;
        }
        if (!ConfigHandler.burnHostilesAroundWhenPlaced) {
            return;
        }
        class_2248 block = blockState.method_26204();
        if (!CompareBlockFunctions.blockIsInRegistryHolder((class_2248)block, (class_6862)class_3481.field_23799)) {
            return;
        }
        if (!ConfigHandler.enableEffectForNormalCampfires && block.equals(class_2246.field_17350)) {
            return;
        }
        if (!ConfigHandler.enableEffectForSoulCampfires && block.equals(class_2246.field_23860)) {
            return;
        }
        int r = (int)((double)ConfigHandler.preventHostilesRadius * ConfigHandler.burnHostilesRadiusModifier);
        List entities = world.method_8335(null, new class_238((double)(ppos.method_10263() - r), (double)(ppos.method_10264() - r), (double)(ppos.method_10260() - r), (double)(ppos.method_10263() + r), (double)(ppos.method_10264() + r), (double)(ppos.method_10260() + r)));
        for (class_1297 entity : entities) {
            if (!Util.entityIsHostile(entity) || !entity.method_5809()) continue;
            entity.method_5646();
            entity.method_5639(2);
        }
    }
}

