/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.nohostilesaroundcampfire_common_forge.events;

import com.natamus.collective_common_forge.functions.CompareBlockFunctions;
import com.natamus.collective_common_forge.functions.EntityFunctions;
import com.natamus.collective_common_forge.functions.FABFunctions;
import com.natamus.collective_common_forge.functions.HashMapFunctions;
import com.natamus.nohostilesaroundcampfire_common_forge.config.ConfigHandler;
import com.natamus.nohostilesaroundcampfire_common_forge.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public class CampfireEvent {
    private static final HashMap<Level, List<BlockPos>> checkCampfireBurn = new HashMap();

    public static void onWorldTick(ServerLevel level) {
        if (((List)HashMapFunctions.computeIfAbsent(checkCampfireBurn, (Object)level, k -> new ArrayList())).size() > 0) {
            BlockPos campfirepos = checkCampfireBurn.get(level).get(0);
            BlockState campfirestate = level.m_8055_(campfirepos);
            if (CompareBlockFunctions.blockIsInRegistryHolder((Block)campfirestate.m_60734_(), (TagKey)BlockTags.f_13087_)) {
                boolean islit = true;
                if (ConfigHandler.campfireMustBeLit) {
                    islit = (Boolean)campfirestate.m_61143_((Property)CampfireBlock.f_51227_);
                }
                if (islit) {
                    int r = (int)((double)ConfigHandler.preventHostilesRadius * ConfigHandler.burnHostilesRadiusModifier);
                    List entities = level.m_45933_(null, new AABB((double)(campfirepos.m_123341_() - r), (double)(campfirepos.m_123342_() - r), (double)(campfirepos.m_123343_() - r), (double)(campfirepos.m_123341_() + r), (double)(campfirepos.m_123342_() + r), (double)(campfirepos.m_123343_() + r)));
                    for (Entity entity : entities) {
                        if (!Util.entityIsHostile(entity)) continue;
                        entity.m_20254_(30);
                    }
                }
            }
            checkCampfireBurn.get(level).remove(0);
        }
    }

    public static boolean onEntityCheckSpawn(Mob entity, ServerLevel world, BlockPos spawnerPos, MobSpawnType spawnReason) {
        if (entity == null) {
            return true;
        }
        if (entity.m_19880_().contains("nohostilesaroundcampfire.checked")) {
            return true;
        }
        entity.m_20049_("nohostilesaroundcampfire.checked");
        if (!ConfigHandler.preventMobSpawnerSpawns && EntityFunctions.isEntityFromSpawner((Entity)entity).booleanValue()) {
            return true;
        }
        if (!Util.entityIsHostile((Entity)entity)) {
            return true;
        }
        List nearbycampfires = FABFunctions.getAllTaggedTileEntityPositionsNearbyEntity((TagKey)BlockTags.f_13087_, (Integer)ConfigHandler.preventHostilesRadius, (Level)world, (Entity)entity);
        if (nearbycampfires.size() == 0) {
            return true;
        }
        BlockPos campfire = null;
        for (BlockPos nearbycampfire : nearbycampfires) {
            Boolean issignalling;
            Boolean islit;
            BlockState campfirestate = world.m_8055_(nearbycampfire);
            Block block = campfirestate.m_60734_();
            if (!(block instanceof CampfireBlock) || !ConfigHandler.enableEffectForNormalCampfires && block.equals(Blocks.f_50683_) || !ConfigHandler.enableEffectForSoulCampfires && block.equals(Blocks.f_50684_) || ConfigHandler.campfireMustBeLit && !(islit = (Boolean)campfirestate.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue() || ConfigHandler.campfireMustBeSignalling && !(issignalling = (Boolean)campfirestate.m_61143_((Property)CampfireBlock.f_51228_)).booleanValue()) continue;
            campfire = nearbycampfire.m_7949_();
            break;
        }
        if (campfire == null) {
            return true;
        }
        List passengers = entity.m_20197_();
        if (passengers.size() > 0) {
            for (Entity passenger : passengers) {
                passenger.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        return false;
    }

    public static void onCampfirePlace(Level level, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        if (level.f_46443_) {
            return;
        }
        if (!ConfigHandler.burnHostilesAroundWhenPlaced) {
            return;
        }
        Block block = blockState.m_60734_();
        if (!CompareBlockFunctions.blockIsInRegistryHolder((Block)block, (TagKey)BlockTags.f_13087_)) {
            return;
        }
        if (!ConfigHandler.enableEffectForNormalCampfires && block.equals(Blocks.f_50683_)) {
            return;
        }
        if (!ConfigHandler.enableEffectForSoulCampfires && block.equals(Blocks.f_50684_)) {
            return;
        }
        ((List)HashMapFunctions.computeIfAbsent(checkCampfireBurn, (Object)level, k -> new ArrayList())).add(blockPos.m_7949_());
    }

    public static boolean onRightClickCampfireBlock(Level level, Player player, InteractionHand hand, BlockPos pos, BlockHitResult hitVec) {
        if (level.f_46443_) {
            return true;
        }
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (CompareBlockFunctions.blockIsInRegistryHolder((Block)block, (TagKey)BlockTags.f_13087_)) {
            if (((Boolean)state.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
                return true;
            }
            if (player.m_21205_().m_41720_() instanceof FlintAndSteelItem || player.m_21206_().m_41720_() instanceof FlintAndSteelItem) {
                ((List)HashMapFunctions.computeIfAbsent(checkCampfireBurn, (Object)level, k -> new ArrayList())).add(pos.m_7949_());
            }
        }
        return true;
    }

    public static void onCampfireBreak(Level world, Player player, BlockPos ppos, BlockState blockState, BlockEntity blockEntity, ItemStack itemStack) {
        if (world.f_46443_) {
            return;
        }
        if (!ConfigHandler.burnHostilesAroundWhenPlaced) {
            return;
        }
        Block block = blockState.m_60734_();
        if (!CompareBlockFunctions.blockIsInRegistryHolder((Block)block, (TagKey)BlockTags.f_13087_)) {
            return;
        }
        if (!ConfigHandler.enableEffectForNormalCampfires && block.equals(Blocks.f_50683_)) {
            return;
        }
        if (!ConfigHandler.enableEffectForSoulCampfires && block.equals(Blocks.f_50684_)) {
            return;
        }
        int r = (int)((double)ConfigHandler.preventHostilesRadius * ConfigHandler.burnHostilesRadiusModifier);
        List entities = world.m_45933_(null, new AABB((double)(ppos.m_123341_() - r), (double)(ppos.m_123342_() - r), (double)(ppos.m_123343_() - r), (double)(ppos.m_123341_() + r), (double)(ppos.m_123342_() + r), (double)(ppos.m_123343_() + r)));
        for (Entity entity : entities) {
            if (!Util.entityIsHostile(entity) || !entity.m_6060_()) continue;
            entity.m_20095_();
            entity.m_20254_(2);
        }
    }
}

