/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.api;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.github.lukebemish.dynamic_asset_generator.api.IPathAwareInputStreamSource;
import io.github.lukebemish.dynamic_asset_generator.impl.CommonRegisters;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;

public interface IResourceGenerator
extends IPathAwareInputStreamSource {
    public static final Codec<IResourceGenerator> CODEC = ExtraCodecs.m_184415_(() -> new Codec<Codec<? extends IResourceGenerator>>(){

        public <T> DataResult<Pair<Codec<? extends IResourceGenerator>, T>> decode(DynamicOps<T> ops, T input) {
            return ResourceLocation.f_135803_.decode(ops, input).flatMap(keyValuePair -> !CommonRegisters.IRESOURCEGENERATORS.containsKey(keyValuePair.getFirst()) ? DataResult.error((String)("Unknown dynamic resource generator type: " + keyValuePair.getFirst())) : DataResult.success((Object)keyValuePair.mapFirst(arg_0 -> CommonRegisters.IRESOURCEGENERATORS.get(arg_0))));
        }

        public <T> DataResult<T> encode(Codec<? extends IResourceGenerator> input, DynamicOps<T> ops, T prefix) {
            ResourceLocation key = (ResourceLocation)CommonRegisters.IRESOURCEGENERATORS.inverse().get(input);
            if (key == null) {
                return DataResult.error((String)("Unregistered dynamic resource generator type: " + input));
            }
            Object toMerge = ops.createString(key.toString());
            return ops.mergeToPrimitive(prefix, toMerge);
        }
    }).dispatch(IResourceGenerator::codec, Function.identity());

    public static void register(ResourceLocation rl, Codec<? extends IResourceGenerator> reader) {
        CommonRegisters.IRESOURCEGENERATORS.put((Object)rl, reader);
    }

    public Codec<? extends IResourceGenerator> codec();
}

