/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.api;

import io.github.lukebemish.dynamic_asset_generator.api.IInputStreamSource;
import io.github.lukebemish.dynamic_asset_generator.api.IPathAwareInputStreamSource;
import io.github.lukebemish.dynamic_asset_generator.impl.DynamicAssetGenerator;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class ResourceCache {
    protected static final String SOURCE_JSON_DIR = "dynamic_asset_generator";
    protected List<Supplier<? extends IPathAwareInputStreamSource>> cache = new ArrayList<Supplier<? extends IPathAwareInputStreamSource>>();
    private final List<Runnable> resetListeners = new ArrayList<Runnable>();

    public Map<ResourceLocation, Supplier<InputStream>> getResources() {
        HashMap<ResourceLocation, Supplier<InputStream>> outputsSetup = new HashMap<ResourceLocation, Supplier<InputStream>>();
        this.cache.forEach(p -> {
            try {
                IPathAwareInputStreamSource source = (IPathAwareInputStreamSource)p.get();
                Set<ResourceLocation> rls = source.getLocations();
                rls.forEach(rl -> outputsSetup.put((ResourceLocation)rl, this.wrapSafeData((ResourceLocation)rl, source.get((ResourceLocation)rl))));
            }
            catch (Throwable e) {
                DynamicAssetGenerator.LOGGER.error("Issue setting up IPathAwareInputStreamSource:", e);
            }
        });
        Map<ResourceLocation, Supplier<InputStream>> outputs = outputsSetup;
        if (this.shouldCache()) {
            outputs = this.wrapCachedData(outputs);
        }
        return outputs;
    }

    public void planResetListener(Runnable listener) {
        this.resetListeners.add(listener);
    }

    public void reset() {
        this.resetListeners.forEach(Runnable::run);
    }

    private Supplier<InputStream> wrapSafeData(ResourceLocation rl, Supplier<InputStream> supplier) {
        return () -> {
            try {
                return (InputStream)supplier.get();
            }
            catch (Throwable e) {
                DynamicAssetGenerator.LOGGER.error("Issue reading supplying resource {}:", (Object)rl, (Object)e);
                return null;
            }
        };
    }

    private Map<ResourceLocation, Supplier<InputStream>> wrapCachedData(Map<ResourceLocation, Supplier<InputStream>> map) {
        HashMap<ResourceLocation, Supplier<InputStream>> output = new HashMap<ResourceLocation, Supplier<InputStream>>();
        map.forEach((rl, supplier) -> {
            Supplier<InputStream> wrapped = () -> this.lambda$wrapCachedData$3(rl, (Supplier)supplier);
            output.put((ResourceLocation)rl, wrapped);
        });
        return output;
    }

    public abstract boolean shouldCache();

    public abstract Path cachePath();

    public void planSource(ResourceLocation rl, IInputStreamSource source) {
        this.cache.add(ResourceCache.wrap(() -> Set.of(rl), source));
    }

    public void planSource(Supplier<Set<ResourceLocation>> locations, IInputStreamSource source) {
        this.cache.add(ResourceCache.wrap(locations, source));
    }

    public void planSource(Set<ResourceLocation> locations, IInputStreamSource source) {
        this.cache.add(ResourceCache.wrap(() -> locations, source));
    }

    public void planSource(IPathAwareInputStreamSource source) {
        this.cache.add(() -> source);
    }

    public void planSource(Supplier<? extends IPathAwareInputStreamSource> source) {
        this.cache.add(source);
    }

    public static Supplier<IPathAwareInputStreamSource> wrap(final Supplier<Set<ResourceLocation>> rls, final IInputStreamSource source) {
        return () -> new IPathAwareInputStreamSource(){

            @Override
            @NotNull
            public Set<ResourceLocation> getLocations() {
                return (Set)rls.get();
            }

            @Override
            @NotNull
            public Supplier<InputStream> get(ResourceLocation outRl) {
                return source.get(outRl);
            }
        };
    }

    private /* synthetic */ InputStream lambda$wrapCachedData$3(ResourceLocation rl, Supplier supplier) {
        try {
            Path path = this.cachePath().resolve(rl.m_135827_()).resolve(rl.m_135815_());
            if (!Files.exists(path.getParent(), new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            if (!Files.exists(path, new LinkOption[0])) {
                InputStream stream = (InputStream)supplier.get();
                if (stream != null) {
                    Files.copy(stream, path, StandardCopyOption.REPLACE_EXISTING);
                } else {
                    return null;
                }
            }
            return new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
        }
        catch (IOException e) {
            DynamicAssetGenerator.LOGGER.error("Could not cache resource...", (Throwable)e);
            return null;
        }
    }
}

