/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.api;

import com.google.common.collect.ImmutableList;
import io.github.lukebemish.dynamic_asset_generator.api.InvisibleResourceProvider;
import io.github.lukebemish.dynamic_asset_generator.impl.DynamicAssetGenerator;
import io.github.lukebemish.dynamic_asset_generator.impl.platform.Services;
import io.github.lukebemish.dynamic_asset_generator.impl.util.InvisibleProviderUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import org.jetbrains.annotations.ApiStatus;

public class ServerPrePackRepository {
    private static List<PackResources> resources = new ArrayList<PackResources>();

    @ApiStatus.Internal
    public static void loadResources(List<PackResources> r) {
        for (InvisibleResourceProvider provider : InvisibleProviderUtils.INVISIBLE_RESOURCE_PROVIDERS) {
            provider.reset(PackType.SERVER_DATA);
        }
        resources = (List)Stream.concat(r.stream().filter(p -> !p.m_8017_().contains(DynamicAssetGenerator.CLIENT_PACK) && !p.m_8017_().contains(DynamicAssetGenerator.SERVER_PACK)), InvisibleProviderUtils.INVISIBLE_RESOURCE_PROVIDERS.stream().map(InvisibleProviderUtils::constructPlaceholderResourcesFromProvider)).collect(ImmutableList.toImmutableList());
    }

    public static List<PackResources> getResources() {
        return resources;
    }

    public static InputStream getResource(ResourceLocation rl) throws IOException {
        InputStream resource = null;
        for (PackResources r : resources) {
            if (!r.m_7211_(PackType.SERVER_DATA, rl)) continue;
            if (resource != null) {
                resource.close();
            }
            resource = r.m_8031_(PackType.SERVER_DATA, rl);
        }
        if (resource != null) {
            return resource;
        }
        throw new IOException("Could not find data in pre-load: " + rl.toString());
    }

    public static Stream<InputStream> getResources(ResourceLocation rl) throws IOException {
        ArrayList<InputStream> out = new ArrayList<InputStream>();
        for (PackResources packResources : Services.DEGROUPER.unpackPacks(resources)) {
            InputStream resource;
            if (packResources.m_8017_().contains(DynamicAssetGenerator.SERVER_PACK) || !packResources.m_7211_(PackType.SERVER_DATA, rl) || (resource = packResources.m_8031_(PackType.SERVER_DATA, rl)) == null) continue;
            out.add(0, resource);
        }
        if (!out.isEmpty()) {
            return out.stream();
        }
        throw new IOException("Could not find data in pre-load: " + rl.toString());
    }
}

