/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.api.client;

import io.github.lukebemish.dynamic_asset_generator.api.ResourceCache;
import io.github.lukebemish.dynamic_asset_generator.api.client.ClientPrePackRepository;
import io.github.lukebemish.dynamic_asset_generator.impl.DynamicAssetGenerator;
import io.github.lukebemish.dynamic_asset_generator.impl.ModConfig;
import io.github.lukebemish.dynamic_asset_generator.impl.client.JsonResourceGeneratorReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;

public class AssetResourceCache
extends ResourceCache {
    public static final AssetResourceCache INSTANCE = new AssetResourceCache();
    public static final ResourceLocation EMPTY_TEXTURE = new ResourceLocation("dynamic_asset_generator", "textures/empty.png");

    private AssetResourceCache() {
        this.planSource(() -> new JsonResourceGeneratorReader(AssetResourceCache.getSourceJsons()));
    }

    static Map<ResourceLocation, String> getSourceJsons() {
        HashMap<ResourceLocation, String> rls = new HashMap<ResourceLocation, String>();
        HashSet<ResourceLocation> available = new HashSet<ResourceLocation>();
        for (PackResources packResources : ClientPrePackRepository.getResources()) {
            if (packResources.m_8017_().equals(DynamicAssetGenerator.CLIENT_PACK) || packResources.m_8017_().equals(DynamicAssetGenerator.SERVER_PACK)) continue;
            for (String namespace : packResources.m_5698_(PackType.CLIENT_RESOURCES)) {
                for (ResourceLocation rl : packResources.m_214146_(PackType.CLIENT_RESOURCES, namespace, "dynamic_asset_generator", x -> x.toString().endsWith(".json"))) {
                    if (!packResources.m_7211_(PackType.CLIENT_RESOURCES, rl)) continue;
                    available.add(rl);
                }
            }
        }
        for (ResourceLocation resourceLocation : available) {
            try {
                InputStream resource = ClientPrePackRepository.getResource(resourceLocation);
                try {
                    String text = new String(resource.readAllBytes(), StandardCharsets.UTF_8);
                    rls.put(resourceLocation, text);
                }
                finally {
                    if (resource == null) continue;
                    resource.close();
                }
            }
            catch (IOException e) {
                DynamicAssetGenerator.LOGGER.error("Issues loading resource source jsons...");
            }
        }
        return rls;
    }

    @Override
    public boolean shouldCache() {
        return DynamicAssetGenerator.getConfig().cacheAssets();
    }

    @Override
    public Path cachePath() {
        return ModConfig.ASSET_CACHE_FOLDER;
    }
}

