/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.api.client;

import com.google.common.collect.ImmutableList;
import io.github.lukebemish.dynamic_asset_generator.api.InvisibleResourceProvider;
import io.github.lukebemish.dynamic_asset_generator.impl.DynamicAssetGenerator;
import io.github.lukebemish.dynamic_asset_generator.impl.platform.Services;
import io.github.lukebemish.dynamic_asset_generator.impl.util.InvisibleProviderUtils;
import io.github.lukebemish.dynamic_asset_generator.mixin.IPackRepositoryMixin;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import org.jetbrains.annotations.ApiStatus;

public class ClientPrePackRepository {
    private static List<? extends PackResources> resources = new ArrayList<PackResources>();

    @ApiStatus.Internal
    public static void resetResources() {
        resources = null;
    }

    public static List<? extends PackResources> getResources() {
        if (resources == null || resources.isEmpty()) {
            for (InvisibleResourceProvider provider : InvisibleProviderUtils.INVISIBLE_RESOURCE_PROVIDERS) {
                provider.reset(PackType.CLIENT_RESOURCES);
            }
            resources = (List)Stream.concat(Services.DEGROUPER.unpackPacks((List)((IPackRepositoryMixin)Minecraft.m_91087_().m_91099_()).getSelected().stream().filter(p -> !p.m_10446_().contains(DynamicAssetGenerator.CLIENT_PACK) && !p.m_10446_().contains(DynamicAssetGenerator.SERVER_PACK)).map(Pack::m_10445_).filter(p -> !p.m_8017_().contains(DynamicAssetGenerator.CLIENT_PACK) && !p.m_8017_().contains(DynamicAssetGenerator.SERVER_PACK)).collect(ImmutableList.toImmutableList())).stream(), InvisibleProviderUtils.INVISIBLE_RESOURCE_PROVIDERS.stream().map(InvisibleProviderUtils::constructPlaceholderResourcesFromProvider)).collect(ImmutableList.toImmutableList());
        }
        return resources;
    }

    public static InputStream getResource(ResourceLocation rl) throws IOException {
        InputStream resource = null;
        for (PackResources packResources : ClientPrePackRepository.getResources()) {
            if (packResources.m_8017_().equals(DynamicAssetGenerator.CLIENT_PACK) || !packResources.m_7211_(PackType.CLIENT_RESOURCES, rl)) continue;
            if (resource != null) {
                resource.close();
            }
            resource = packResources.m_8031_(PackType.CLIENT_RESOURCES, rl);
        }
        if (resource != null) {
            return resource;
        }
        throw new IOException("Could not find resource in pre-load: " + rl.toString());
    }

    public static Stream<InputStream> getResources(ResourceLocation rl) throws IOException {
        ArrayList<InputStream> out = new ArrayList<InputStream>();
        for (PackResources packResources : ClientPrePackRepository.getResources()) {
            InputStream resource;
            if (packResources.m_8017_().contains(DynamicAssetGenerator.CLIENT_PACK) || !packResources.m_7211_(PackType.CLIENT_RESOURCES, rl) || (resource = packResources.m_8031_(PackType.CLIENT_RESOURCES, rl)) == null) continue;
            out.add(0, resource);
        }
        if (!out.isEmpty()) {
            return out.stream();
        }
        throw new IOException("Could not find asset in pre-load: " + rl.toString());
    }
}

