/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.api.client.generators;

import io.github.lukebemish.dynamic_asset_generator.api.client.generators.ITexSource;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TexSourceDataHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ITexSource.class);
    private Map<String, Object> dataMap = new HashMap<String, Object>();

    public TexSourceDataHolder() {
        this.put(Logger.class, LOGGER);
    }

    public TexSourceDataHolder(TexSourceDataHolder old) {
        this.dataMap.putAll(old.dataMap);
    }

    public <T> void put(Class<? extends T> clazz, T data) {
        this.dataMap.put(clazz.descriptorString(), data);
    }

    @Nullable
    public <T> T get(Class<? extends T> clazz) {
        try {
            return (T)this.dataMap.get(clazz.descriptorString());
        }
        catch (ClassCastException ignored) {
            return null;
        }
    }

    public Logger getLogger() {
        Logger logger = this.get(Logger.class);
        return logger == null ? LOGGER : logger;
    }
}

