/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.ITexSource;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.TexSourceDataHolder;
import io.github.lukebemish.dynamic_asset_generator.impl.client.NativeImageHelper;
import io.github.lukebemish.dynamic_asset_generator.impl.client.util.SafeImageExtraction;
import io.github.lukebemish.dynamic_asset_generator.impl.util.MultiCloser;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public record AnimationSplittingSource(Map<String, TimeAwareSource> sources, ITexSource generator) implements ITexSource
{
    public static final Codec<AnimationSplittingSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, TimeAwareSource.CODEC).fieldOf("sources").forGetter(AnimationSplittingSource::sources), (App)ITexSource.CODEC.fieldOf("generator").forGetter(AnimationSplittingSource::generator)).apply((Applicative)instance, AnimationSplittingSource::new));

    @Override
    public Codec<? extends ITexSource> codec() {
        return CODEC;
    }

    @Override
    @NotNull
    public Supplier<NativeImage> getSupplier(TexSourceDataHolder data) throws JsonSyntaxException {
        HashMap sources = new HashMap();
        HashMap times = new HashMap();
        this.sources.forEach((key, source) -> {
            sources.put(key, source.source().getSupplier(data));
            times.put(key, source.scale());
        });
        return () -> {
            HashMap<String, NativeImage> images = new HashMap<String, NativeImage>();
            sources.forEach((str, sup) -> images.put((String)str, (NativeImage)sup.get()));
            try (MultiCloser closer = new MultiCloser(images.values());){
                if (sources.isEmpty()) {
                    data.getLogger().error("No sources given...");
                    NativeImage nativeImage = null;
                    return nativeImage;
                }
                List imageList = images.values().stream().toList();
                List<Integer> counts = images.entrySet().stream().map(entry -> (Integer)times.get(entry.getKey()) * AnimationSplittingSource.getFrameCount((NativeImage)entry.getValue())).toList();
                for (int j = 0; j < counts.size(); ++j) {
                    int i = counts.get(j);
                    if (i != 0) continue;
                    data.getLogger().error("Source not shaped correctly for an animation...\n{}", imageList.get(j));
                    NativeImage nativeImage = null;
                    return nativeImage;
                }
                int lcm = AnimationSplittingSource.lcm(counts);
                int lcmWidth = AnimationSplittingSource.lcm(imageList.stream().map(NativeImage::m_84982_).toList());
                NativeImage output = NativeImageHelper.of(NativeImage.Format.RGBA, lcmWidth, lcmWidth * lcm, false);
                for (int i = 0; i < lcm; ++i) {
                    HashMap<String, NativeImage> map = new HashMap<String, NativeImage>();
                    int finalI = i;
                    images.forEach((str, old) -> map.put((String)str, AnimationSplittingSource.getPartialImage(old, finalI, (Integer)times.get(str))));
                    try (ImageCollection collection = new ImageCollection(map);){
                        TexSourceDataHolder newData = new TexSourceDataHolder(data);
                        newData.put(ImageCollection.class, collection);
                        NativeImage supplied = this.generator.getSupplier(newData).get();
                        int sWidth = supplied.m_84982_();
                        if (sWidth != supplied.m_85084_()) {
                            data.getLogger().error("Generator created non-square image...\n{}", (Object)this.generator);
                            NativeImage nativeImage = null;
                            return nativeImage;
                        }
                        int scale = lcmWidth / sWidth;
                        for (int x = 0; x < lcmWidth; ++x) {
                            for (int y = 0; y < lcmWidth; ++y) {
                                int color = SafeImageExtraction.get(supplied, x / scale, y / scale);
                                output.m_84988_(x, y + i * lcmWidth, color);
                            }
                        }
                        continue;
                    }
                }
                NativeImage nativeImage = output;
                return nativeImage;
            }
        };
    }

    private static int gcd(int i1, int i2) {
        if (i1 == 0 || i2 == 0) {
            return i1 + i2;
        }
        int max = Math.max(i1, i2);
        int min = Math.min(i1, i2);
        return AnimationSplittingSource.gcd(max % min, min);
    }

    private static int lcm(int i1, int i2) {
        return i1 * i2 / AnimationSplittingSource.gcd(i1, i2);
    }

    @ApiStatus.Internal
    public static int lcm(List<Integer> ints) {
        if (ints.size() <= 1) {
            return ints.get(0);
        }
        if (ints.size() == 2) {
            return AnimationSplittingSource.lcm(ints.get(0), ints.get(1));
        }
        ArrayList<Integer> newInts = new ArrayList<Integer>(ints.subList(2, ints.size()));
        newInts.add(0, AnimationSplittingSource.lcm(ints.get(0), ints.get(1)));
        return AnimationSplittingSource.lcm(newInts);
    }

    private static int getFrameCount(NativeImage image) {
        return image.m_85084_() / image.m_84982_();
    }

    private static NativeImage getPartialImage(NativeImage input, int part, int scale) {
        int numFull = input.m_85084_() / input.m_84982_();
        int size = input.m_84982_();
        NativeImage output = NativeImageHelper.of(input.m_85102_(), size, size, false);
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                output.m_84988_(x, y, SafeImageExtraction.get(input, x, part / scale % numFull * size + y));
            }
        }
        return output;
    }

    public static class ImageCollection
    implements Closeable {
        private final Map<String, NativeImage> map;

        public ImageCollection(Map<String, NativeImage> map) {
            this.map = new HashMap<String, NativeImage>(map);
        }

        @Override
        public void close() {
            this.map.values().forEach(NativeImage::close);
        }

        public NativeImage get(String key) {
            NativeImage input = this.map.get(key);
            NativeImage newImage = new NativeImage(input.m_85102_(), input.m_84982_(), input.m_85084_(), false);
            newImage.m_85054_(input);
            return newImage;
        }

        protected Collection<NativeImage> get() {
            return this.map.values();
        }
    }

    public record TimeAwareSource(ITexSource source, int scale) {
        public static final Codec<TimeAwareSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ITexSource.CODEC.fieldOf("source").forGetter(TimeAwareSource::source), (App)Codec.INT.optionalFieldOf("scale", (Object)1).forGetter(TimeAwareSource::scale)).apply((Applicative)instance, TimeAwareSource::new));
    }
}

