/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.ITexSource;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.TexSourceDataHolder;
import io.github.lukebemish.dynamic_asset_generator.impl.DynamicAssetGenerator;
import io.github.lukebemish.dynamic_asset_generator.impl.client.NativeImageHelper;
import io.github.lukebemish.dynamic_asset_generator.impl.client.util.SafeImageExtraction;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public record Crop(int totalSize, int startX, int sizeX, int startY, int sizeY, ITexSource input) implements ITexSource
{
    public static final Codec<Crop> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("total_size").forGetter(Crop::totalSize), (App)Codec.INT.fieldOf("start_x").forGetter(Crop::startX), (App)Codec.INT.fieldOf("size_x").forGetter(Crop::sizeX), (App)Codec.INT.fieldOf("start_y").forGetter(Crop::startY), (App)Codec.INT.fieldOf("size_y").forGetter(Crop::sizeY), (App)ITexSource.CODEC.fieldOf("input").forGetter(Crop::input)).apply((Applicative)instance, Crop::new));

    public Codec<Crop> codec() {
        return CODEC;
    }

    @Override
    @NotNull
    public Supplier<NativeImage> getSupplier(TexSourceDataHolder data) throws JsonSyntaxException {
        Supplier<NativeImage> suppliedInput = this.input().getSupplier(data);
        return () -> {
            try (NativeImage inImg = (NativeImage)suppliedInput.get();){
                int scale;
                if (inImg == null) {
                    data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.input());
                    NativeImage nativeImage = null;
                    return nativeImage;
                }
                if (this.totalSize() == 0) {
                    data.getLogger().error("Total image width must be non-zero");
                }
                if ((scale = inImg.m_84982_() / this.totalSize()) == 0) {
                    data.getLogger().error("Image scale turned out to be 0! Image is {} wide, total width is {}", (Object)inImg.m_84982_(), (Object)this.totalSize());
                }
                int distX = this.sizeX() * scale;
                int distY = this.sizeY() * scale;
                if (distY < 1 || distX < 1) {
                    DynamicAssetGenerator.LOGGER.error("Bounds of image are negative! {}, {}", (Object)this.sizeX(), (Object)this.sizeY());
                    NativeImage nativeImage = null;
                    return nativeImage;
                }
                NativeImage out = NativeImageHelper.of(NativeImage.Format.RGBA, distX, distY, false);
                for (int x = 0; x < distX; ++x) {
                    for (int y = 0; y < distY; ++y) {
                        int c = SafeImageExtraction.get(inImg, x + this.startX() * scale, y + this.startY() * scale);
                        out.m_84988_(x, y, c);
                    }
                }
                NativeImage nativeImage = out;
                return nativeImage;
            }
        };
    }
}

