/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.ITexSource;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.TexSourceDataHolder;
import io.github.lukebemish.dynamic_asset_generator.impl.client.NativeImageHelper;
import io.github.lukebemish.dynamic_asset_generator.impl.client.palette.ColorHolder;
import io.github.lukebemish.dynamic_asset_generator.impl.client.util.SafeImageExtraction;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public record Mask(ITexSource input, ITexSource mask) implements ITexSource
{
    public static final Codec<Mask> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ITexSource.CODEC.fieldOf("input").forGetter(Mask::input), (App)ITexSource.CODEC.fieldOf("mask").forGetter(Mask::mask)).apply((Applicative)instance, Mask::new));

    @Override
    public Codec<? extends ITexSource> codec() {
        return CODEC;
    }

    @Override
    @NotNull
    public Supplier<NativeImage> getSupplier(TexSourceDataHolder data) throws JsonSyntaxException {
        Supplier<NativeImage> input = this.input().getSupplier(data);
        Supplier<NativeImage> mask = this.mask().getSupplier(data);
        return () -> {
            try (NativeImage inImg = (NativeImage)input.get();){
                NativeImage nativeImage;
                block26: {
                    NativeImage maskImg;
                    block24: {
                        NativeImage nativeImage2;
                        block25: {
                            block22: {
                                NativeImage nativeImage3;
                                block23: {
                                    maskImg = (NativeImage)mask.get();
                                    if (maskImg != null) break block22;
                                    data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.mask());
                                    nativeImage3 = null;
                                    if (maskImg == null) break block23;
                                    maskImg.close();
                                }
                                return nativeImage3;
                            }
                            if (inImg != null) break block24;
                            data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.input());
                            nativeImage2 = null;
                            if (maskImg == null) break block25;
                            maskImg.close();
                        }
                        return nativeImage2;
                    }
                    try {
                        int iys;
                        int ixs;
                        int mys;
                        int mxs;
                        int maxY;
                        int maxX = Math.max(inImg.m_84982_(), maskImg.m_84982_());
                        int n = maxY = inImg.m_84982_() > maskImg.m_84982_() ? inImg.m_85084_() : maskImg.m_85084_();
                        if ((double)maskImg.m_84982_() / ((double)maskImg.m_85084_() * 1.0) <= (double)maxX / ((double)maxY * 1.0)) {
                            mxs = maxX / maskImg.m_84982_();
                            mys = maxY / maskImg.m_84982_();
                        } else {
                            mxs = maxX / maskImg.m_85084_();
                            mys = maxY / maskImg.m_85084_();
                        }
                        if ((double)inImg.m_84982_() / ((double)inImg.m_85084_() * 1.0) <= (double)maxX / ((double)maxY * 1.0)) {
                            ixs = inImg.m_84982_() / maxX;
                            iys = inImg.m_84982_() / maxY;
                        } else {
                            ixs = inImg.m_85084_() / maxX;
                            iys = inImg.m_85084_() / maxY;
                        }
                        NativeImage out = NativeImageHelper.of(NativeImage.Format.RGBA, maxX, maxY, false);
                        for (int x = 0; x < maxX; ++x) {
                            for (int y = 0; y < maxY; ++y) {
                                ColorHolder mC = ColorHolder.fromColorInt(SafeImageExtraction.get(maskImg, x / mxs, y / mys));
                                ColorHolder iC = ColorHolder.fromColorInt(SafeImageExtraction.get(inImg, x / ixs, y / iys));
                                ColorHolder o = iC.withA(mC.getA() * iC.getA());
                                out.m_84988_(x, y, ColorHolder.toColorInt(o));
                            }
                        }
                        nativeImage = out;
                        if (maskImg == null) break block26;
                    }
                    catch (Throwable throwable) {
                        if (maskImg != null) {
                            try {
                                maskImg.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    maskImg.close();
                }
                return nativeImage;
            }
        };
    }
}

