/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.ITexSource;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.TexSourceDataHolder;
import io.github.lukebemish.dynamic_asset_generator.impl.client.util.ImageUtils;
import java.io.IOException;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public record TextureReader(ResourceLocation path) implements ITexSource
{
    public static final Codec<TextureReader> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("path").forGetter(TextureReader::path)).apply((Applicative)instance, TextureReader::new));

    @Override
    public Codec<? extends ITexSource> codec() {
        return CODEC;
    }

    @Override
    @NotNull
    public Supplier<NativeImage> getSupplier(TexSourceDataHolder data) throws JsonSyntaxException {
        ResourceLocation outRl = new ResourceLocation(this.path().m_135827_(), "textures/" + this.path().m_135815_() + ".png");
        return () -> {
            try {
                return ImageUtils.getImage(outRl);
            }
            catch (IOException e) {
                data.getLogger().error("Issue loading texture: {}", (Object)this.path());
                return null;
            }
        };
    }
}

