/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.ITexSource;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.TexSourceDataHolder;
import io.github.lukebemish.dynamic_asset_generator.impl.client.NativeImageHelper;
import io.github.lukebemish.dynamic_asset_generator.impl.client.util.SafeImageExtraction;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public record Transform(ITexSource input, int rotate, boolean flip) implements ITexSource
{
    public static final Codec<Transform> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ITexSource.CODEC.fieldOf("input").forGetter(Transform::input), (App)Codec.INT.fieldOf("rotate").forGetter(Transform::rotate), (App)Codec.BOOL.fieldOf("flip").forGetter(Transform::flip)).apply((Applicative)instance, Transform::new));

    @Override
    public Codec<? extends ITexSource> codec() {
        return CODEC;
    }

    @Override
    @NotNull
    public Supplier<NativeImage> getSupplier(TexSourceDataHolder data) throws JsonSyntaxException {
        Supplier<NativeImage> input = this.input().getSupplier(data);
        return () -> {
            NativeImage inImg = (NativeImage)input.get();
            if (inImg == null) {
                data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.input().toString());
                return null;
            }
            NativeImage output = inImg;
            for (int i = 0; i < this.rotate(); ++i) {
                output = Transform.clockwiseRotate(output);
            }
            if (this.flip()) {
                NativeImage output2 = NativeImageHelper.of(output.m_85102_(), output.m_84982_(), output.m_85084_(), false);
                for (int x = 0; x < output.m_84982_(); ++x) {
                    for (int y = 0; y < output.m_85084_(); ++y) {
                        output2.m_84988_(output.m_84982_() - 1 - x, y, SafeImageExtraction.get(output, x, y));
                    }
                }
                output.close();
                output = output2;
            }
            return output;
        };
    }

    private static NativeImage clockwiseRotate(NativeImage input) {
        int w = input.m_84982_();
        int h = input.m_85084_();
        NativeImage output = NativeImageHelper.of(input.m_85102_(), h, w, false);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                output.m_84988_(y, w - x - 1, SafeImageExtraction.get(input, x, y));
            }
        }
        input.close();
        return output;
    }
}

