/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.mask;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.ITexSource;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.TexSourceDataHolder;
import io.github.lukebemish.dynamic_asset_generator.impl.client.NativeImageHelper;
import io.github.lukebemish.dynamic_asset_generator.impl.client.palette.ColorHolder;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public record GrowMask(ITexSource source, float growth, float cutoff) implements ITexSource
{
    public static final Codec<GrowMask> CODEC = RecordCodecBuilder.create(i -> i.group((App)ITexSource.CODEC.fieldOf("source").forGetter(GrowMask::source), (App)Codec.FLOAT.optionalFieldOf("growth", (Object)Float.valueOf(0.0625f)).forGetter(GrowMask::growth), (App)Codec.FLOAT.optionalFieldOf("cutoff", (Object)Float.valueOf(0.5f)).forGetter(GrowMask::cutoff)).apply((Applicative)i, GrowMask::new));

    @Override
    public Codec<? extends ITexSource> codec() {
        return CODEC;
    }

    @Override
    @NotNull
    public Supplier<NativeImage> getSupplier(TexSourceDataHolder data) throws JsonSyntaxException {
        Supplier<NativeImage> input = this.source.getSupplier(data);
        return () -> {
            try (NativeImage inImg = (NativeImage)input.get();){
                if (inImg == null) {
                    data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.source);
                    NativeImage nativeImage = null;
                    return nativeImage;
                }
                int width = inImg.m_84982_();
                int height = inImg.m_85084_();
                int toGrow = (int)Math.floor((float)width * this.growth);
                int filterSize = toGrow * toGrow * 2 + 1;
                int[] xs = new int[filterSize];
                int[] ys = new int[filterSize];
                int counter = 0;
                for (int x = -toGrow; x <= toGrow; ++x) {
                    int y = -toGrow;
                    while (y <= toGrow) {
                        xs[counter] = x;
                        ys[counter] = y++;
                        ++counter;
                    }
                }
                NativeImage out = NativeImageHelper.of(NativeImage.Format.RGBA, width, height, false);
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < width; ++y) {
                        boolean shouldGrow = false;
                        for (int i : xs) {
                            for (int j : ys) {
                                int x1 = x + i;
                                int y1 = y + j;
                                if (x1 < toGrow || y1 < toGrow || x1 >= width - toGrow || y1 >= width - toGrow || !(ColorHolder.fromColorInt(inImg.m_84985_(x1, y1)).getA() > this.cutoff)) continue;
                                shouldGrow = true;
                            }
                        }
                        if (shouldGrow) {
                            out.m_84988_(x, y, -1);
                            continue;
                        }
                        out.m_84988_(x, y, 0);
                    }
                }
                NativeImage nativeImage = out;
                return nativeImage;
            }
        };
    }
}

