/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.mask;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.ITexSource;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.TexSourceDataHolder;
import io.github.lukebemish.dynamic_asset_generator.impl.client.NativeImageHelper;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public record InvertMask(ITexSource source) implements ITexSource
{
    public static final Codec<InvertMask> CODEC = RecordCodecBuilder.create(i -> i.group((App)ITexSource.CODEC.fieldOf("source").forGetter(InvertMask::source)).apply((Applicative)i, InvertMask::new));

    @Override
    public Codec<? extends ITexSource> codec() {
        return CODEC;
    }

    @Override
    @NotNull
    public Supplier<NativeImage> getSupplier(TexSourceDataHolder data) throws JsonSyntaxException {
        Supplier<NativeImage> input = this.source.getSupplier(data);
        return () -> {
            try (NativeImage inImg = (NativeImage)input.get();){
                if (inImg == null) {
                    data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.source);
                    NativeImage nativeImage = null;
                    return nativeImage;
                }
                int width = inImg.m_84982_();
                int height = inImg.m_85084_();
                NativeImage out = NativeImageHelper.of(NativeImage.Format.RGBA, width, height, false);
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < width; ++y) {
                        int source = inImg.m_84985_(x, y);
                        out.m_84988_(x, y, ~source);
                    }
                }
                NativeImage nativeImage = out;
                return nativeImage;
            }
        };
    }
}

