/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.api.templates;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;

public record TagFile(List<Value> values, boolean replace) {
    public static final Codec<TagFile> CODEC = RecordCodecBuilder.create(p -> p.group((App)Value.CODEC.listOf().optionalFieldOf("values", List.of()).forGetter(TagFile::values), (App)Codec.BOOL.optionalFieldOf("replace", (Object)false).forGetter(TagFile::replace)).apply((Applicative)p, TagFile::new));

    static DataResult<TagFile> fromStream(InputStream stream) {
        DataResult dataResult;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        try {
            JsonElement json = JsonParser.parseReader((Reader)reader);
            dataResult = CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | RuntimeException e) {
                return DataResult.error((String)("Error reading tag file: " + e.getMessage()));
            }
        }
        reader.close();
        return dataResult;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Value {
        public static final Codec<Value> CODEC = Codec.either(DirectReference.CODEC, TagReference.CODEC).xmap(either -> (Value)either.map(directReference -> directReference, tagReference -> tagReference), value -> {
            Either either;
            if (value instanceof DirectReference) {
                DirectReference directReference = (DirectReference)value;
                either = Either.left((Object)directReference);
            } else {
                either = Either.right((Object)((TagReference)value));
            }
            return either;
        });
    }

    public record TagReference(ResourceLocation id) implements Value
    {
        public static final Codec<TagReference> CODEC = Codec.STRING.flatXmap(s -> {
            if (!s.startsWith("#")) {
                return DataResult.error((String)"Tag must start with '#'");
            }
            ResourceLocation location = ResourceLocation.m_135820_((String)s.substring(1));
            if (location == null) {
                return DataResult.error((String)"Invalid tag location");
            }
            return DataResult.success((Object)location);
        }, rl -> DataResult.success((Object)("#" + rl))).xmap(TagReference::new, TagReference::id);
    }

    public record DirectReference(ResourceLocation id, boolean required) implements Value
    {
        public static final Codec<DirectReference> CODEC = Codec.either((Codec)ResourceLocation.f_135803_.xmap(rl -> new DirectReference((ResourceLocation)rl, true), DirectReference::id), (Codec)RecordCodecBuilder.create(p -> p.group((App)ResourceLocation.f_135803_.fieldOf("id").forGetter(DirectReference::id), (App)Codec.BOOL.optionalFieldOf("required", (Object)true).forGetter(DirectReference::required)).apply((Applicative)p, DirectReference::new))).xmap(either -> (DirectReference)either.map(Function.identity(), Function.identity()), Either::right);
    }
}

