/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.impl;

import io.github.lukebemish.dynamic_asset_generator.api.DataResourceCache;
import io.github.lukebemish.dynamic_asset_generator.impl.DynamicAssetGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class DynAssetGenServerDataPack
implements PackResources {
    private Map<ResourceLocation, Supplier<InputStream>> streams;

    private Map<ResourceLocation, Supplier<InputStream>> getStreams() {
        if (this.streams == null) {
            this.streams = DataResourceCache.INSTANCE.getResources();
        }
        return this.streams;
    }

    public DynAssetGenServerDataPack() {
        DataResourceCache.INSTANCE.reset();
    }

    @Nullable
    public InputStream m_5542_(String location) {
        return null;
    }

    public InputStream m_8031_(PackType packType, ResourceLocation location) throws IOException {
        if (packType == PackType.SERVER_DATA && this.getStreams().containsKey(location)) {
            InputStream stream = this.getStreams().get(location).get();
            if (stream != null) {
                return stream;
            }
            throw new IOException("Data is null: " + location);
        }
        throw new IOException("Could not find resource in generated data: " + location);
    }

    public Collection<ResourceLocation> m_214146_(PackType packType, String namespace, String directory, Predicate<ResourceLocation> predicate) {
        ArrayList<ResourceLocation> locations = new ArrayList<ResourceLocation>();
        if (packType == PackType.SERVER_DATA) {
            for (ResourceLocation key : this.getStreams().keySet()) {
                if (!key.m_135815_().startsWith(directory) || !key.m_135827_().equals(namespace) || !predicate.test(key) || this.getStreams().get(key).get() == null) continue;
                locations.add(key);
            }
        }
        return locations;
    }

    public boolean m_7211_(PackType packType, ResourceLocation location) {
        if (packType == PackType.SERVER_DATA && this.getStreams().containsKey(location)) {
            return this.getStreams().get(location).get() != null;
        }
        return false;
    }

    public Set<String> m_5698_(PackType packType) {
        HashSet<String> namespaces = new HashSet<String>();
        if (packType == PackType.SERVER_DATA) {
            for (ResourceLocation key : this.getStreams().keySet()) {
                namespaces.add(key.m_135827_());
            }
        }
        return namespaces;
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> serializer) {
        if (serializer.m_7991_().equals("pack")) {
            return (T)DynamicAssetGenerator.SERVER_PACK_METADATA;
        }
        return null;
    }

    public String m_8017_() {
        return DynamicAssetGenerator.SERVER_PACK;
    }

    public void close() {
    }
}

