/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.impl.util;

import io.github.lukebemish.dynamic_asset_generator.api.ConditionalInvisibleResourceProvider;
import io.github.lukebemish.dynamic_asset_generator.api.InvisibleResourceProvider;
import io.github.lukebemish.dynamic_asset_generator.impl.DynamicAssetGenerator;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public final class InvisibleProviderUtils {
    public static final List<InvisibleResourceProvider> INVISIBLE_RESOURCE_PROVIDERS = Stream.concat(ServiceLoader.load(InvisibleResourceProvider.class).stream().map(ServiceLoader.Provider::get), ServiceLoader.load(ConditionalInvisibleResourceProvider.class).stream().map(ServiceLoader.Provider::get).filter(ConditionalInvisibleResourceProvider::isAvailable).map(ConditionalInvisibleResourceProvider::get)).toList();

    private InvisibleProviderUtils() {
    }

    public static PackResources constructPlaceholderResourcesFromProvider(final InvisibleResourceProvider provider) {
        return new PackResources(){

            @Nullable
            public InputStream m_5542_(String fileName) {
                return null;
            }

            public InputStream m_8031_(PackType type, ResourceLocation location) {
                return provider.getResource(type, location);
            }

            public Collection<ResourceLocation> m_214146_(PackType type, String namespace, String path, Predicate<ResourceLocation> filter) {
                return provider.getResources(type, namespace, path, filter);
            }

            public boolean m_7211_(PackType type, ResourceLocation location) {
                return provider.hasResource(type, location);
            }

            public Set<String> m_5698_(PackType type) {
                return provider.getNamespaces(type);
            }

            @Nullable
            public <T> T m_5550_(MetadataSectionSerializer<T> deserializer) {
                return null;
            }

            public String m_8017_() {
                return "placeholder__" + provider.getClass().getName().toLowerCase(Locale.ROOT).replace('.', '_').replace('$', '_');
            }

            public void close() {
            }
        };
    }

    static {
        DynamicAssetGenerator.LOGGER.debug("Loaded invisible resource providers: {}", INVISIBLE_RESOURCE_PROVIDERS);
    }
}

