/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.client.gui.entry;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.pickupnotifier.client.gui.entry.DisplayEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Rarity;

public class ExperienceDisplayEntry
extends DisplayEntry {
    private static final ResourceLocation EXPERIENCE_ORB_TEXTURES = new ResourceLocation("textures/entity/experience_orb.png");
    private final Component name;

    public ExperienceDisplayEntry(Component name, int amount) {
        super(amount, Rarity.UNCOMMON);
        this.name = name;
    }

    @Override
    protected Component getEntryName() {
        return this.name;
    }

    @Override
    public boolean mayMergeWith(DisplayEntry other) {
        return other instanceof ExperienceDisplayEntry;
    }

    @Override
    protected int getInventoryCount(Inventory inventory) {
        return 0;
    }

    @Override
    protected void renderSprite(Minecraft minecraft, PoseStack poseStack, int posX, int posY, float scale) {
        int textureOffset = this.getXpTexture(this.getDisplayAmount());
        int x = textureOffset % 4 * 16;
        int y = textureOffset / 4 * 16;
        float color = (float)this.getRemainingTicks() / 4.0f;
        float r = (Mth.m_14031_((float)color) + 1.0f) * 0.5f;
        float g = 1.0f;
        float b = (Mth.m_14031_((float)(color + 4.1887903f)) + 1.0f) * 0.1f;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)EXPERIENCE_ORB_TEXTURES);
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)1.0f);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)posX, (int)posY, (float)x, (float)y, (int)16, (int)16, (int)64, (int)64);
    }

    private int getXpTexture(int displayCount) {
        if (displayCount >= 2477) {
            return 10;
        }
        if (displayCount >= 1237) {
            return 9;
        }
        if (displayCount >= 617) {
            return 8;
        }
        if (displayCount >= 307) {
            return 7;
        }
        if (displayCount >= 149) {
            return 6;
        }
        if (displayCount >= 73) {
            return 5;
        }
        if (displayCount >= 37) {
            return 4;
        }
        if (displayCount >= 17) {
            return 3;
        }
        if (displayCount >= 7) {
            return 2;
        }
        return displayCount >= 3 ? 1 : 0;
    }
}

