/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.handler;

import fuzs.pickupnotifier.PickUpNotifier;
import fuzs.pickupnotifier.config.ServerConfig;
import fuzs.pickupnotifier.network.S2CTakeItemMessage;
import fuzs.pickupnotifier.network.S2CTakeItemStackMessage;
import fuzs.puzzleslib.network.Message;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ForgeItemPickupHandler {
    private ItemStack cachedStack = ItemStack.f_41583_;

    @SubscribeEvent
    public void onEntityItemPickup$1(EntityItemPickupEvent evt) {
        if (((ServerConfig)PickUpNotifier.CONFIG.get(ServerConfig.class)).backpackCompat && !evt.getItem().m_32055_().m_41619_() && !evt.getItem().m_213877_()) {
            this.cachedStack = evt.getItem().m_32055_().m_41777_();
        }
    }

    @SubscribeEvent
    public void onEntityItemPickup$2(EntityItemPickupEvent evt) {
        ItemEntity itemEntity = evt.getItem();
        Player player = evt.getEntity();
        ItemStack stack = itemEntity.m_32055_();
        if (((ServerConfig)PickUpNotifier.CONFIG.get(ServerConfig.class)).backpackCompat && evt.isCanceled()) {
            if (!this.cachedStack.m_41619_()) {
                boolean sendTakeMessage = false;
                int takeAmount = this.cachedStack.m_41613_() - stack.m_41613_();
                if (takeAmount > 0) {
                    this.cachedStack.m_41764_(takeAmount);
                    sendTakeMessage = true;
                } else if (evt.getItem().m_213877_()) {
                    sendTakeMessage = true;
                }
                if (sendTakeMessage) {
                    PickUpNotifier.NETWORK.sendTo((Message)new S2CTakeItemStackMessage(this.cachedStack), (ServerPlayer)player);
                }
            }
            this.cachedStack = ItemStack.f_41583_;
        } else if (((ServerConfig)PickUpNotifier.CONFIG.get(ServerConfig.class)).partialPickUps && !itemEntity.m_213877_() && !itemEntity.m_32063_() && (itemEntity.m_32056_() == null || itemEntity.lifespan - itemEntity.m_32059_() <= 200 || itemEntity.m_32056_().equals(player.m_20148_()))) {
            int itemAmount = 0;
            if (player.m_150109_().m_36062_() != -1) {
                itemAmount = stack.m_41613_();
            } else {
                int slotWithRemainingSpace = player.m_150109_().m_36050_(stack);
                if (slotWithRemainingSpace != -1) {
                    itemAmount = this.getSpaceAtIndex(player.m_150109_(), slotWithRemainingSpace, stack);
                }
            }
            if (itemAmount > 0) {
                PickUpNotifier.NETWORK.sendTo((Message)new S2CTakeItemMessage(itemEntity.m_19879_(), itemAmount), (ServerPlayer)player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerItemPickup(PlayerEvent.ItemPickupEvent evt) {
        if (!((ServerConfig)PickUpNotifier.CONFIG.get(ServerConfig.class)).partialPickUps && !evt.getOriginalEntity().m_213877_()) {
            PickUpNotifier.NETWORK.sendTo((Message)new S2CTakeItemMessage(evt.getOriginalEntity().m_19879_(), evt.getStack().m_41613_()), (ServerPlayer)evt.getEntity());
        }
    }

    private int getSpaceAtIndex(Inventory inventory, int slotIndex, ItemStack stack) {
        int itemCount = stack.m_41613_();
        ItemStack itemstack = inventory.m_8020_(slotIndex);
        int itemSpace = itemCount;
        if (itemCount > itemstack.m_41741_() - itemstack.m_41613_()) {
            itemSpace = itemstack.m_41741_() - itemstack.m_41613_();
        }
        if (itemSpace > inventory.m_6893_() - itemstack.m_41613_()) {
            itemSpace = inventory.m_6893_() - itemstack.m_41613_();
        }
        return itemSpace;
    }
}

