/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases;

import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pepjebs.mapatlases.capabilities.MapCollectionCap;
import pepjebs.mapatlases.client.MapAtlasesClient;
import pepjebs.mapatlases.config.MapAtlasesClientConfig;
import pepjebs.mapatlases.config.MapAtlasesConfig;
import pepjebs.mapatlases.integration.MoonlightCompat;
import pepjebs.mapatlases.item.MapAtlasItem;
import pepjebs.mapatlases.lifecycle.MapAtlasesServerEvents;
import pepjebs.mapatlases.networking.MapAtlasesNetworking;
import pepjebs.mapatlases.recipe.MapAtlasCreateRecipe;
import pepjebs.mapatlases.recipe.MapAtlasesAddRecipe;
import pepjebs.mapatlases.recipe.MapAtlasesCutExistingRecipe;

@Mod(value="map_atlases")
public class MapAtlasesMod {
    public static final String MOD_ID = "map_atlases";
    public static final Logger LOGGER = LogManager.getLogger((String)"Map Atlases");
    public static final Supplier<MapAtlasItem> MAP_ATLAS;
    private static final DeferredRegister<RecipeSerializer<?>> RECIPES;
    private static final DeferredRegister<MenuType<?>> MENU_TYPES;
    private static final DeferredRegister<SoundEvent> SOUND_EVENTS;
    private static final DeferredRegister<Item> ITEMS;
    public static final Supplier<RecipeSerializer<MapAtlasCreateRecipe>> MAP_ATLAS_CREATE_RECIPE;
    public static final Supplier<RecipeSerializer<MapAtlasesAddRecipe>> MAP_ATLAS_ADD_RECIPE;
    public static final Supplier<RecipeSerializer<MapAtlasesCutExistingRecipe>> MAP_ATLAS_CUT_RECIPE;
    public static final Supplier<SoundEvent> ATLAS_OPEN_SOUND_EVENT;
    public static final Supplier<SoundEvent> ATLAS_PAGE_TURN_SOUND_EVENT;
    public static final Supplier<SoundEvent> ATLAS_CREATE_MAP_SOUND_EVENT;
    public static final TagKey<Item> STICKY_ITEMS;
    public static final boolean CURIOS;
    public static final boolean TRINKETS;
    public static final boolean SUPPLEMENTARIES;
    public static final boolean MOONLIGHT;
    public static final boolean TWILIGHTFOREST = false;
    private static boolean hack;

    public MapAtlasesMod() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(MapCollectionCap::register);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            MapAtlasesClient.init();
        }
        if (MOONLIGHT) {
            MoonlightCompat.init();
        }
        RECIPES.register(bus);
        MENU_TYPES.register(bus);
        ITEMS.register(bus);
        SOUND_EVENTS.register(bus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MapAtlasesConfig.spec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)MapAtlasesClientConfig.spec);
        MapAtlasesNetworking.register();
        MinecraftForge.EVENT_BUS.register(MapAtlasesServerEvents.class);
    }

    private static Supplier<SoundEvent> regSound(String name) {
        return SOUND_EVENTS.register(name, () -> new SoundEvent(MapAtlasesMod.res(name)));
    }

    public static ResourceLocation res(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static boolean containsHack() {
        return hack;
    }

    public static void setMapInInentoryHack(boolean value) {
        hack = value;
    }

    static {
        RECIPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)MOD_ID);
        MENU_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)MOD_ID);
        SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)MOD_ID);
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)MOD_ID);
        ATLAS_OPEN_SOUND_EVENT = MapAtlasesMod.regSound("atlas_open");
        ATLAS_PAGE_TURN_SOUND_EVENT = MapAtlasesMod.regSound("atlas_page_turn");
        ATLAS_CREATE_MAP_SOUND_EVENT = MapAtlasesMod.regSound("atlas_create_map");
        STICKY_ITEMS = ItemTags.create((ResourceLocation)MapAtlasesMod.res("sticky_crafting_items"));
        CURIOS = ModList.get().isLoaded("curios");
        TRINKETS = ModList.get().isLoaded("trinkets");
        SUPPLEMENTARIES = ModList.get().isLoaded("supplementaries");
        MOONLIGHT = ModList.get().isLoaded("moonlight");
        MAP_ATLAS_CREATE_RECIPE = RECIPES.register("crafting_atlas", MapAtlasCreateRecipe.Serializer::new);
        MAP_ATLAS_ADD_RECIPE = RECIPES.register("adding_atlas", () -> new SimpleRecipeSerializer(MapAtlasesAddRecipe::new));
        MAP_ATLAS_CUT_RECIPE = RECIPES.register("cutting_atlas", () -> new SimpleRecipeSerializer(MapAtlasesCutExistingRecipe::new));
        MAP_ATLAS = ITEMS.register("atlas", () -> new MapAtlasItem(new Item.Properties().m_41491_(CreativeModeTab.f_40756_).m_41487_(16)));
        hack = false;
    }
}

