/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.capabilities;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;
import pepjebs.mapatlases.capabilities.MapKey;
import pepjebs.mapatlases.utils.MapDataHolder;
import pepjebs.mapatlases.utils.MapType;
import pepjebs.mapatlases.utils.Slice;

public interface IMapCollection {
    public boolean add(int var1, Level var2);

    public boolean remove(MapDataHolder var1);

    public int getCount();

    public boolean isEmpty();

    public byte getScale();

    public int[] getAllIds();

    public Collection<ResourceKey<Level>> getAvailableDimensions();

    public Collection<MapType> getAvailableTypes(ResourceKey<Level> var1);

    public Collection<Integer> getHeightTree(ResourceKey<Level> var1, MapType var2);

    public List<MapDataHolder> selectSection(ResourceKey<Level> var1, Slice var2);

    public List<MapDataHolder> filterSection(ResourceKey<Level> var1, Slice var2, Predicate<MapItemSavedData> var3);

    @Nullable
    default public MapDataHolder selectWithKey(int x, int z, ResourceKey<Level> dimension, Slice slice) {
        return this.selectWithKey(new MapKey(dimension, x, z, slice));
    }

    public MapDataHolder selectWithKey(MapKey var1);

    @Nullable
    public MapDataHolder getClosest(double var1, double var3, ResourceKey<Level> var5, Slice var6);

    @Nullable
    default public MapDataHolder getClosest(Player player, Slice group) {
        return this.getClosest(player.m_20185_(), player.m_20189_(), (ResourceKey<Level>)player.f_19853_.m_46472_(), group);
    }

    public Collection<MapDataHolder> getAll();
}

