/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.Material;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.utils.MapDataHolder;
import pepjebs.mapatlases.utils.MapType;

public abstract class AbstractAtlasWidget
extends GuiComponent {
    public static final Material MAP_BORDER = new Material(InventoryMenu.f_39692_, MapAtlasesMod.res("gui/screen/map_border"));
    public static final int MAP_DIMENSION = 128;
    protected final int atlasesCount;
    protected int mapBlocksSize;
    private MapItemSavedData mapWherePlayerIs;
    protected boolean followingPlayer = true;
    protected double currentXCenter;
    protected double currentZCenter;
    protected float zoomLevel = 3.0f;
    protected boolean rotatesWithPlayer = false;
    protected boolean drawBigPlayerMarker = true;

    protected AbstractAtlasWidget(int atlasesCount) {
        this.atlasesCount = atlasesCount;
    }

    protected void initialize(MapDataHolder originalCenter) {
        this.mapWherePlayerIs = originalCenter.data;
        this.mapBlocksSize = (1 << this.mapWherePlayerIs.f_77890_) * 128;
        this.currentXCenter = this.mapWherePlayerIs.f_77885_;
        this.currentZCenter = this.mapWherePlayerIs.f_77886_;
        this.zoomLevel = (float)this.atlasesCount * originalCenter.type.getDefaultZoomFactor();
    }

    public void drawAtlas(PoseStack poseStack, int x, int y, int width, int height, Player player, float zoomLevelDim, boolean showBorders, MapType type, int light) {
        poseStack.m_85836_();
        float widgetScale = (float)width / (float)(this.atlasesCount * 128);
        float zoomScale = (float)this.atlasesCount / zoomLevelDim;
        int intXCenter = (int)this.currentXCenter;
        int intZCenter = (int)this.currentZCenter;
        int scaleIndex = this.mapBlocksSize / 128;
        ColumnPos c = type.getCenter(intXCenter, intZCenter, this.mapBlocksSize);
        int centerMapX = c.f_140723_();
        int centerMapZ = c.f_140724_();
        poseStack.m_85837_((double)((float)x + (float)width / 2.0f), (double)((float)y + (float)height / 2.0f), 0.0);
        poseStack.m_85841_(widgetScale * zoomScale, widgetScale * zoomScale, -1.0f);
        MultiBufferSource.BufferSource vcp = Minecraft.m_91087_().m_91269_().m_110104_();
        ArrayList<Matrix4f> outlineHack = new ArrayList<Matrix4f>();
        this.applyScissors(poseStack, x, y, x + width, y + height);
        double mapCenterOffsetX = this.currentXCenter - (double)centerMapX;
        double mapCenterOffsetZ = this.currentZCenter - (double)centerMapZ;
        if (this.rotatesWithPlayer) {
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f - player.m_146908_()));
        }
        poseStack.m_85837_(-mapCenterOffsetX / (double)scaleIndex, -mapCenterOffsetZ / (double)scaleIndex, 0.0);
        double sideLength = (float)this.mapBlocksSize * zoomScale;
        int radius = (int)((float)(this.mapBlocksSize * this.atlasesCount) * 0.71f);
        int o = Mth.m_14167_((float)zoomLevelDim);
        double maxDist = this.rotatesWithPlayer ? Mth.m_144952_((double)((double)radius + sideLength * 0.71)) : (double)(o + 1) * sideLength * 0.5;
        for (int i = o; i >= -o; --i) {
            for (int j = o; j >= -o; --j) {
                boolean shouldDraw;
                double gridCenterI = (double)i * sideLength;
                double gridCenterJ = (double)j * sideLength;
                if (this.rotatesWithPlayer) {
                    double distance = Mth.m_211589_((double)(gridCenterI - mapCenterOffsetZ * (double)zoomScale), (double)(gridCenterJ - mapCenterOffsetX * (double)zoomScale));
                    shouldDraw = distance <= maxDist;
                } else {
                    boolean bl = shouldDraw = Math.abs(gridCenterI - mapCenterOffsetZ * (double)zoomScale) < maxDist && Math.abs(gridCenterJ - mapCenterOffsetX * (double)zoomScale) < maxDist;
                }
                if (!shouldDraw) continue;
                this.getAndDrawMap(player, poseStack, centerMapX, centerMapZ, vcp, outlineHack, i, j, light);
            }
        }
        vcp.m_109911_();
        if (showBorders) {
            VertexConsumer outlineVC = MAP_BORDER.m_119194_((MultiBufferSource)vcp, RenderType::m_110497_);
            int a = 50;
            for (Matrix4f matrix4f : outlineHack) {
                outlineVC.m_85982_(matrix4f, 0.0f, 128.0f, -0.02f).m_6122_(255, 255, 255, a).m_7421_(0.0f, 1.0f).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                outlineVC.m_85982_(matrix4f, 128.0f, 128.0f, -0.02f).m_6122_(255, 255, 255, a).m_7421_(1.0f, 1.0f).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                outlineVC.m_85982_(matrix4f, 128.0f, 0.0f, -0.02f).m_6122_(255, 255, 255, a).m_7421_(1.0f, 0.0f).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                outlineVC.m_85982_(matrix4f, 0.0f, 0.0f, -0.02f).m_6122_(255, 255, 255, a).m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            }
            vcp.m_109911_();
        }
        poseStack.m_85849_();
        GuiComponent.m_240060_();
    }

    protected void applyScissors(PoseStack graphics, int x, int y, int x1, int y1) {
        GuiComponent.m_239260_((int)x, (int)y, (int)x1, (int)y1);
    }

    private void getAndDrawMap(Player player, PoseStack poseStack, int centerMapX, int centerMapZ, MultiBufferSource.BufferSource vcp, List<Matrix4f> outlineHack, int i, int j, int light) {
        int reqXCenter = centerMapX + j * this.mapBlocksSize;
        int reqZCenter = centerMapZ + i * this.mapBlocksSize;
        MapDataHolder state = this.getMapWithCenter(reqXCenter, reqZCenter);
        if (state != null) {
            MapItemSavedData data = state.data;
            boolean drawPlayerIcons = !this.drawBigPlayerMarker && data.f_77887_.equals((Object)player.f_19853_.m_46472_());
            this.drawMap(player, poseStack, vcp, outlineHack, i, j, state, drawPlayerIcons, light);
        }
    }

    @Nullable
    public abstract MapDataHolder getMapWithCenter(int var1, int var2);

    public void setFollowingPlayer(boolean followingPlayer) {
        this.followingPlayer = followingPlayer;
    }

    private void drawMap(Player player, PoseStack poseStack, MultiBufferSource.BufferSource vcp, List<Matrix4f> outlineHack, int ix, int iy, MapDataHolder state, boolean drawPlayerIcons, int light) {
        int curMapComponentX = 128 * iy - 64;
        int curMapComponentY = 128 * ix - 64;
        poseStack.m_85836_();
        poseStack.m_85837_((double)curMapComponentX, (double)curMapComponentY, 0.0);
        MapItemSavedData data = state.data;
        ArrayList removed = new ArrayList();
        ArrayList<AbstractMap.SimpleEntry<String, MapDecoration>> added = new ArrayList<AbstractMap.SimpleEntry<String, MapDecoration>>();
        for (Map.Entry e : data.f_77894_.entrySet()) {
            MapDecoration decoration = (MapDecoration)e.getValue();
            MapDecoration.Type type = decoration.m_77803_();
            if (type == MapDecoration.Type.PLAYER_OFF_MAP || type == MapDecoration.Type.PLAYER_OFF_LIMITS) {
                if (data == this.mapWherePlayerIs && drawPlayerIcons) {
                    MapDecoration d2 = (MapDecoration)e.getValue();
                    removed.add(e);
                    added.add(new AbstractMap.SimpleEntry<String, MapDecoration>((String)e.getKey(), new MapDecoration(MapDecoration.Type.PLAYER, d2.m_77804_(), d2.m_77805_(), AbstractAtlasWidget.getPlayerMarkerRot(player), d2.m_77810_())));
                    continue;
                }
                removed.add(e);
                continue;
            }
            if (type != MapDecoration.Type.PLAYER || drawPlayerIcons) continue;
            removed.add(e);
        }
        removed.forEach(d -> data.f_77894_.remove(d.getKey()));
        added.forEach(d -> data.f_77894_.put((String)d.getKey(), (MapDecoration)d.getValue()));
        Minecraft.m_91087_().f_91063_.m_109151_().m_168771_(poseStack, (MultiBufferSource)vcp, state.id, data, false, light);
        poseStack.m_85849_();
        for (Map.Entry e : removed) {
            data.f_77894_.put((String)e.getKey(), (MapDecoration)e.getValue());
        }
    }

    private static byte getPlayerMarkerRot(Player p) {
        float pRotation = p.m_146908_();
        pRotation = (float)((double)pRotation + ((double)pRotation < 0.0 ? -8.0 : 8.0));
        return (byte)((double)pRotation * 16.0 / 360.0);
    }

    public static int round(int num, int mod) {
        int t = num % mod;
        if (t < (int)Math.floor((double)mod / 2.0)) {
            return num - t;
        }
        return num + mod - t;
    }
}

